/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfd;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.ToByteArray;
import io.vproxy.base.util.Utils;
import java.util.Objects;

public class MacAddress
implements ToByteArray {
    public static final MacAddress ZERO = new MacAddress(new byte[]{0, 0, 0, 0, 0, 0});
    public static final MacAddress BROADCAST = new MacAddress("ff:ff:ff:ff:ff:ff");
    public final ByteArray bytes;
    private final int value0;
    private final int value1;

    public MacAddress(byte[] bytes) {
        this(ByteArray.from(bytes));
    }

    public MacAddress(ByteArray bytes) {
        this.bytes = bytes.copy().unmodifiable();
        this.value0 = bytes.int32(0);
        this.value1 = bytes.uint16(4);
    }

    public MacAddress(String mac) {
        if (mac.length() != 17) {
            throw new IllegalArgumentException();
        }
        String[] split = mac.split(":");
        if (split.length != 6) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = Utils.allocateByteArrayInitZero(6);
        for (int i = 0; i < 6; ++i) {
            String s = split[i];
            if (s.length() != 2) {
                throw new IllegalArgumentException();
            }
            try {
                bytes[i] = (byte)Integer.parseInt(s, 16);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.bytes = ByteArray.from(bytes).unmodifiable();
        this.value0 = this.bytes.int32(0);
        this.value1 = this.bytes.uint16(4);
    }

    public boolean isBroadcast() {
        for (int i = 0; i < this.bytes.length(); ++i) {
            byte b = this.bytes.get(i);
            if (b == -1) continue;
            return false;
        }
        return true;
    }

    public boolean isMulticast() {
        return this.isIpv4Multicast() || this.isIpv6Multicast();
    }

    public boolean isUnicast() {
        return !this.isBroadcast() && !this.isMulticast();
    }

    private boolean isIpv4Multicast() {
        if (this.bytes.length() < 4) {
            return false;
        }
        if (this.bytes.get(0) != 1) {
            return false;
        }
        if (this.bytes.get(1) != 0) {
            return false;
        }
        if (this.bytes.get(2) != 94) {
            return false;
        }
        return (this.bytes.get(3) & 0x80) == 0;
    }

    private boolean isIpv6Multicast() {
        if (this.bytes.length() < 2) {
            return false;
        }
        return this.bytes.get(0) == 51 && this.bytes.get(1) == 51;
    }

    public String toString() {
        String hex = this.bytes.toHexString();
        StringBuilder sb = new StringBuilder();
        char[] chars = hex.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i != 0 && i % 2 == 0) {
                sb.append(":");
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MacAddress that = (MacAddress)o;
        return this.value0 == that.value0 && this.value1 == that.value1;
    }

    public int hashCode() {
        return Objects.hash(this.value0, this.value1);
    }

    @Override
    public ByteArray toByteArray() {
        return this.bytes;
    }

    public static MacAddress parseOrNull(String mac) {
        try {
            return new MacAddress(mac);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

