/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Logger;
import io.vproxy.vpacket.PacketDataBuffer;

public abstract class AbstractPacket {
    public static final int FLAG_CHECKSUM_UNNECESSARY = 1;
    protected PacketDataBuffer raw;
    private AbstractPacket parentPacket;
    private boolean requireUpdatingChecksum = false;

    public abstract String from(PacketDataBuffer var1);

    public final ByteArray getRawPacket(int flags) {
        if (this.raw == null) {
            this.raw = new PacketDataBuffer(this.buildPacket(flags));
        } else if ((flags & 1) == 0) {
            this.updateChecksum();
        }
        return this.raw.pktBuf;
    }

    public void clearAllRawPackets() {
        this.clearRawPacket();
    }

    public final void clearRawPacket() {
        if (this.raw != null) {
            this.raw.clearBuffers();
        }
        this.raw = null;
        if (this.parentPacket != null) {
            this.parentPacket.clearRawPacket();
        }
    }

    public boolean isRequireUpdatingChecksum() {
        return this.requireUpdatingChecksum;
    }

    public void clearChecksum() {
        this.checksumSkipped();
    }

    protected final void checksumCalculated() {
        this.requireUpdatingChecksum = false;
    }

    protected final void checksumSkipped() {
        this.requireUpdatingChecksum = true;
    }

    public abstract AbstractPacket copy();

    protected abstract ByteArray buildPacket(int var1);

    protected final void updateChecksum() {
        if (this.requireUpdatingChecksum) {
            this.__updateChecksum();
            this.checksumCalculated();
        } else {
            this.__updateChildrenChecksum();
        }
    }

    protected abstract void __updateChecksum();

    protected abstract void __updateChildrenChecksum();

    protected final void recordParent(AbstractPacket parentPacket) {
        this.parentPacket = parentPacket;
    }

    public abstract String description();

    protected final boolean consumeHeadroomAndMove(int room, int moveLen) {
        if (this.raw == null) {
            assert (Logger.lowLevelDebug("requireMoreHeadroom return false because no raw array"));
            return false;
        }
        if (this.raw.pktOff < room) {
            assert (Logger.lowLevelDebug("requireMoreHeadroom return false because pktOff " + this.raw.pktOff + " < room " + room));
            return false;
        }
        this.raw.pktBuf = this.raw.fullbuf.sub(this.raw.pktOff - room, this.raw.pktBuf.length() + room);
        for (int i = 0; i < moveLen; ++i) {
            this.raw.pktBuf.set(i, this.raw.pktBuf.get(room + i));
        }
        this.raw.pktOff -= room;
        return true;
    }

    protected final void returnHeadroomAndMove(int room, int moveLen) {
        if (this.raw == null) {
            return;
        }
        if (this.raw.pktBuf.length() - room < moveLen) {
            throw new ArrayIndexOutOfBoundsException("pktBuf.length " + this.raw.pktBuf.length() + " - room " + room + " < moveLen " + moveLen);
        }
        for (int i = moveLen - 1; i >= 0; --i) {
            this.raw.pktBuf.set(room + i, this.raw.pktBuf.get(i));
        }
        this.raw.pktBuf = this.raw.pktBuf.sub(room, this.raw.pktBuf.length() - room);
        this.raw.pktOff += room;
    }

    protected final void setPktBufLen(PacketDataBuffer raw, int len) {
        if (raw == null) {
            raw = this.raw;
        }
        if (raw == null) {
            return;
        }
        raw.pad = raw.fullbuf.length() - raw.pktOff - len;
        raw.pktBuf = raw.fullbuf.sub(raw.pktOff, len);
    }
}

