/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.Utils;
import io.vproxy.vfd.IP;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.PacketDataBuffer;
import java.util.Objects;

public class ArpPacket
extends AbstractPacket {
    private int hardwareType;
    private int protocolType;
    private int hardwareSize;
    private int protocolSize;
    private int opcode;
    private ByteArray senderMac;
    private ByteArray senderIp;
    private ByteArray targetMac;
    private ByteArray targetIp;

    @Override
    public String from(PacketDataBuffer raw) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 2) {
            return "input packet length too short for an arp packet: no hardwareType found";
        }
        this.hardwareType = bytes.uint16(0);
        if (bytes.length() < 4) {
            return "input packet length too short for an arp packet: no protocolType found";
        }
        this.protocolType = bytes.uint16(2);
        if (bytes.length() < 5) {
            return "input packet length too short for an arp packet: no hardwareSize found";
        }
        this.hardwareSize = bytes.uint8(4);
        if (bytes.length() < 6) {
            return "input packet length too short for an arp packet: no protocolSize found";
        }
        this.protocolSize = bytes.uint8(5);
        if (bytes.length() < 8) {
            return "input packet length too short for an arp packet: no opcode found";
        }
        this.opcode = bytes.uint16(6);
        if (bytes.length() < 8 + this.hardwareSize) {
            return "input packet length too short for an arp packet: no enough bytes for senderMac";
        }
        this.senderMac = bytes.sub(8, this.hardwareSize);
        if (bytes.length() < 8 + this.hardwareSize + this.protocolSize) {
            return "input packet length too short for an arp packet: no enough bytes for senderIp";
        }
        this.senderIp = bytes.sub(8 + this.hardwareSize, this.protocolSize);
        if (bytes.length() < 8 + this.hardwareSize + this.protocolSize + this.hardwareSize) {
            return "input packet length too short for an arp packet: no enough bytes for targetMac";
        }
        this.targetMac = bytes.sub(8 + this.hardwareSize + this.protocolSize, this.hardwareSize);
        if (bytes.length() < 8 + this.hardwareSize + this.protocolSize + this.hardwareSize + this.protocolSize) {
            return "input packet length too short for an arp packet: no enough bytes for targetIp";
        }
        this.targetIp = bytes.sub(8 + this.hardwareSize + this.protocolSize + this.hardwareSize, this.protocolSize);
        int expectedTotalLen = 8 + this.hardwareSize + this.protocolSize + this.hardwareSize + this.protocolSize;
        if (bytes.length() != expectedTotalLen) {
            assert (Logger.lowLevelDebug("received arp packet has extra bytes: " + (bytes.length() - expectedTotalLen) + " bytes"));
            raw = raw.sub(0, expectedTotalLen);
        }
        this.raw = raw;
        return null;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        if (this.senderMac.length() != this.targetMac.length()) {
            throw new IllegalArgumentException("sender mac and target mac length not the same");
        }
        if (this.senderIp.length() != this.targetIp.length()) {
            throw new IllegalArgumentException("sender ip and target ip length not the same");
        }
        this.hardwareSize = this.senderMac.length();
        this.protocolSize = this.senderIp.length();
        return ByteArray.allocate(8).int16(0, this.hardwareType).int16(2, this.protocolType).set(4, (byte)this.hardwareSize).set(5, (byte)this.protocolSize).int16(6, this.opcode).concat(this.senderMac).concat(this.senderIp).concat(this.targetMac).concat(this.targetIp);
    }

    @Override
    protected void __updateChecksum() {
    }

    @Override
    protected void __updateChildrenChecksum() {
    }

    @Override
    public ArpPacket copy() {
        ArpPacket ret = new ArpPacket();
        ret.hardwareType = this.hardwareType;
        ret.protocolType = this.protocolType;
        ret.hardwareSize = this.hardwareSize;
        ret.protocolSize = this.protocolSize;
        ret.opcode = this.opcode;
        ret.senderMac = this.senderMac;
        ret.senderIp = this.senderIp;
        ret.targetMac = this.targetMac;
        ret.targetIp = this.targetIp;
        return ret;
    }

    @Override
    public String description() {
        return "arp,arp_op=" + this.opcode + ",arp_spa=" + this.senderIp.toHexString() + ",arp_tpa=" + this.targetIp.toHexString() + ",arp_sha=" + this.senderMac.toHexString() + ",arp_tha=" + this.targetMac.toHexString();
    }

    public String toString() {
        if (this.protocolType == 2048) {
            if (this.opcode == 1) {
                if (this.targetIp != null && this.targetIp.length() == 4 && this.senderIp != null && this.senderIp.length() == 4) {
                    return "ArpPacket(who has " + IP.ipStr(this.targetIp.toJavaArray()) + "? tell " + IP.ipStr(this.senderIp.toJavaArray()) + " senderMac=" + Utils.runAvoidNull(() -> this.senderMac.toHexString(), "null") + " targetMac=" + Utils.runAvoidNull(() -> this.targetMac.toHexString(), "null") + ")";
                }
            } else if (this.opcode == 2 && this.senderIp != null && this.senderIp.length() == 4 && this.senderMac != null) {
                return "ArpPacket(" + IP.ipStr(this.senderIp.toJavaArray()) + " is at " + this.senderMac.toHexString() + " targetMac=" + Utils.runAvoidNull(() -> this.targetMac.toHexString(), "null") + " targetIp=" + Utils.runAvoidNull(() -> this.targetIp.toHexString(), "null") + ")";
            }
        }
        return "ArpPacket{hardwareType=" + Utils.toHexString(this.hardwareType) + ", protocolType=" + Utils.toHexString(this.protocolType) + ", hardwareSize=" + this.hardwareSize + ", protocolSize=" + this.protocolSize + ", opcode=" + Utils.toHexString(this.opcode) + ", senderMac=" + Utils.runAvoidNull(() -> this.senderMac.toHexString(), "null") + ", senderIp=" + Utils.runAvoidNull(() -> this.senderIp, "null") + ", targetMac=" + Utils.runAvoidNull(() -> this.targetMac, "null") + ", targetIp=" + Utils.runAvoidNull(() -> this.targetIp, "null") + "}";
    }

    public int getHardwareType() {
        return this.hardwareType;
    }

    public void setHardwareType(int hardwareType) {
        this.clearRawPacket();
        this.hardwareType = hardwareType;
    }

    public int getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(int protocolType) {
        this.clearRawPacket();
        this.protocolType = protocolType;
    }

    public int getHardwareSize() {
        return this.hardwareSize;
    }

    public void setHardwareSize(int hardwareSize) {
        this.clearRawPacket();
        this.hardwareSize = hardwareSize;
    }

    public int getProtocolSize() {
        return this.protocolSize;
    }

    public void setProtocolSize(int protocolSize) {
        this.clearRawPacket();
        this.protocolSize = protocolSize;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.clearRawPacket();
        this.opcode = opcode;
    }

    public ByteArray getSenderMac() {
        return this.senderMac;
    }

    public void setSenderMac(ByteArray senderMac) {
        this.clearRawPacket();
        this.senderMac = senderMac;
    }

    public ByteArray getSenderIp() {
        return this.senderIp;
    }

    public void setSenderIp(ByteArray senderIp) {
        this.clearRawPacket();
        this.senderIp = senderIp;
    }

    public ByteArray getTargetMac() {
        return this.targetMac;
    }

    public void setTargetMac(ByteArray targetMac) {
        this.clearRawPacket();
        this.targetMac = targetMac;
    }

    public ByteArray getTargetIp() {
        return this.targetIp;
    }

    public void setTargetIp(ByteArray targetIp) {
        this.clearRawPacket();
        this.targetIp = targetIp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArpPacket arpPacket = (ArpPacket)o;
        return this.hardwareType == arpPacket.hardwareType && this.protocolType == arpPacket.protocolType && this.hardwareSize == arpPacket.hardwareSize && this.protocolSize == arpPacket.protocolSize && this.opcode == arpPacket.opcode && Objects.equals(this.senderMac, arpPacket.senderMac) && Objects.equals(this.senderIp, arpPacket.senderIp) && Objects.equals(this.targetMac, arpPacket.targetMac) && Objects.equals(this.targetIp, arpPacket.targetIp);
    }

    public int hashCode() {
        return Objects.hash(this.hardwareType, this.protocolType, this.hardwareSize, this.protocolSize, this.opcode, this.senderMac, this.senderIp, this.targetMac, this.targetIp);
    }
}

