/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.Ipv4Packet;
import io.vproxy.vpacket.Ipv6Packet;
import io.vproxy.vpacket.PacketBytes;
import io.vproxy.vpacket.PacketDataBuffer;

public class BSDLoopbackEncapsulation
extends AbstractPacket {
    private int type;
    private AbstractPacket payload;
    public static final int TYPE_IPv4 = 2;
    public static final int TYPE_IPv6 = 24;
    public static final int TYPE_IPv6_2 = 28;
    public static final int TYPE_IPv6_3 = 30;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (this.raw != null) {
            this.raw.pktBuf.int32ReverseNetworkByteOrder(0, type);
        }
        this.type = type;
    }

    public AbstractPacket getPayload() {
        return this.payload;
    }

    public void setPayload(AbstractPacket payload) {
        this.clearRawPacket();
        this.payload = payload;
    }

    @Override
    public void clearAllRawPackets() {
        this.clearRawPacket();
        this.getPayload().clearAllRawPackets();
    }

    @Override
    public String from(PacketDataBuffer raw) {
        PacketDataBuffer data;
        if (raw.pktBuf.length() < 4) {
            return "packet too short";
        }
        this.type = raw.pktBuf.int32ReverseNetworkByteOrder(0);
        AbstractPacket packet = this.type == 2 ? new Ipv4Packet() : (this.type == 24 || this.type == 28 || this.type == 30 ? new Ipv6Packet() : new PacketBytes());
        String err = ((AbstractPacket)packet).from(data = raw.sub(4));
        if (err != null) {
            return err;
        }
        packet.recordParent(this);
        this.setPayload(packet);
        this.raw = raw;
        return null;
    }

    @Override
    public AbstractPacket copy() {
        BSDLoopbackEncapsulation p = new BSDLoopbackEncapsulation();
        p.setType(this.type);
        p.setPayload(this.payload.copy());
        return p;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        ByteArray b = ByteArray.allocate(4).int32ReverseNetworkByteOrder(0, this.type);
        return b.concat(this.payload.getRawPacket(flags));
    }

    @Override
    protected void __updateChecksum() {
        this.payload.__updateChecksum();
    }

    @Override
    protected void __updateChildrenChecksum() {
        this.payload.__updateChecksum();
    }

    @Override
    public String description() {
        return "bsd," + this.payload.description();
    }
}

