/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.EthernetPacket;
import io.vproxy.vpacket.PacketDataBuffer;
import io.vproxy.vpacket.PartialPacket;

public class EtherIPPacket
extends AbstractPacket
implements PartialPacket {
    private int version = 3;
    private EthernetPacket packet;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        if (this.raw != null) {
            int n = this.raw.pktBuf.get(0);
            n &= 0xF;
            this.raw.pktBuf.set(0, (byte)(n |= version << 4 & 0xF0));
        }
        this.version = version;
    }

    public EthernetPacket getPacket() {
        return this.packet;
    }

    public void setPacket(EthernetPacket packet) {
        this.clearRawPacket();
        this.packet = packet;
    }

    @Override
    public String initPartial(PacketDataBuffer raw) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 2) {
            return "input packet length too short for an etherip packet";
        }
        this.version = raw.pktBuf.get(0) >> 4 & 0xF;
        EthernetPacket ether = new EthernetPacket();
        String err = ether.from(raw.sub(2), true);
        if (err != null) {
            return err;
        }
        ether.recordParent(this);
        this.raw = raw;
        return null;
    }

    @Override
    public String initPartial(int level) {
        if (this.packet instanceof PartialPacket) {
            return ((PartialPacket)((Object)this.packet)).initPartial(level);
        }
        return null;
    }

    @Override
    public String from(PacketDataBuffer raw) {
        if (raw.pktBuf.length() < 2) {
            return "input packet length too short for an etherip packet";
        }
        this.version = raw.pktBuf.get(0) >> 4 & 0xF;
        EthernetPacket ether = new EthernetPacket();
        String err = ether.from(raw.sub(2));
        if (err != null) {
            return err;
        }
        ether.recordParent(this);
        this.packet = ether;
        return null;
    }

    @Override
    public AbstractPacket copy() {
        EtherIPPacket pkt = new EtherIPPacket();
        pkt.setVersion(this.version);
        pkt.setPacket(this.packet.copy());
        return pkt;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        ByteArray buf = ByteArray.allocate(2);
        buf.set(0, (byte)(this.version << 4));
        return buf.concat(this.packet.buildPacket(flags));
    }

    @Override
    protected void __updateChecksum() {
        this.__updateChildrenChecksum();
    }

    @Override
    protected void __updateChildrenChecksum() {
        this.packet.updateChecksum();
    }

    @Override
    public String description() {
        return "etherip," + this.packet.description();
    }
}

