/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.Utils;
import io.vproxy.vfd.MacAddress;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.ArpPacket;
import io.vproxy.vpacket.Ipv4Packet;
import io.vproxy.vpacket.Ipv6Packet;
import io.vproxy.vpacket.PacketBytes;
import io.vproxy.vpacket.PacketDataBuffer;
import io.vproxy.vpacket.PartialPacket;
import java.util.Objects;

public class EthernetPacket
extends AbstractPacket {
    public static final int NO_VLAN_CODE = -1;
    public static final int PENDING_VLAN_CODE = -2;
    private MacAddress dst;
    private MacAddress src;
    private int vlan = -1;
    private int type;
    private AbstractPacket packet;
    private PacketDataBuffer packetBytes;

    @Override
    public String from(PacketDataBuffer raw) {
        return this.from(raw, false);
    }

    public String from(PacketDataBuffer raw, boolean allowPartial) {
        AbstractPacket packet;
        ByteArray bytes = raw.pktBuf;
        String err = this.from(bytes, null);
        if (err != null) {
            return err;
        }
        PacketDataBuffer data = this.vlan < 0 ? raw.sub(14) : raw.sub(18);
        boolean isIPPacket = false;
        if (this.type == 2054) {
            packet = new ArpPacket();
        } else if (this.type == 2048) {
            isIPPacket = true;
            packet = new Ipv4Packet();
        } else if (this.type == 34525) {
            isIPPacket = true;
            packet = new Ipv6Packet();
        } else {
            packet = new PacketBytes();
        }
        packet.recordParent(this);
        if (allowPartial && packet instanceof PartialPacket) {
            err = ((PartialPacket)((Object)packet)).initPartial(data);
            if (err == null) {
                this.packetBytes = data;
            }
        } else {
            err = packet.from(data);
        }
        if (err != null) {
            if (isIPPacket) {
                Logger.warn(LogType.SYS_ERROR, "got l3 packet unable to parse, type=" + this.type + ", packet=" + data.pktBuf.toHexString() + ": " + err);
                packet = new PacketBytes();
                packet.from(data);
            } else {
                return err;
            }
        }
        this.packet = packet;
        this.raw = raw;
        return null;
    }

    public String from(ByteArray bytes, AbstractPacket packet) {
        if (bytes.length() < 14) {
            return "input packet length too short for a ethernet packet";
        }
        this.dst = new MacAddress(bytes.sub(0, 6));
        this.src = new MacAddress(bytes.sub(6, 6));
        this.type = bytes.uint16(12);
        if (this.type == 33024) {
            if (bytes.length() < 18) {
                return "input packet length too short for 802.1q ethernet packet";
            }
            byte vlan1 = bytes.get(14);
            byte vlan2 = bytes.get(15);
            this.vlan = (vlan1 & 0xF) << 8 | vlan2 & 0xFF;
            this.type = bytes.uint16(16);
        }
        if (packet != null) {
            this.packet = packet;
            packet.recordParent(this);
        }
        return null;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        ByteArray addrs = this.dst.bytes.copy().concat(this.src.bytes.copy());
        if (this.vlan < 0) {
            ByteArray builtBytes = addrs.concat(ByteArray.allocate(2).int16(0, this.type)).concat(this.packet.getRawPacket(flags));
            if (this.vlan == -2) {
                this.vlan = -1;
            }
            return builtBytes;
        }
        ByteArray tagAndType = ByteArray.allocate(6);
        tagAndType.int16(0, 33024);
        tagAndType.int16(2, this.vlan);
        tagAndType.int16(4, this.type);
        return addrs.concat(tagAndType).concat(this.packet.getRawPacket(flags));
    }

    @Override
    protected void __updateChecksum() {
        this.__updateChildrenChecksum();
    }

    @Override
    protected void __updateChildrenChecksum() {
        this.packet.updateChecksum();
    }

    public PacketDataBuffer getPacketBytes() {
        return this.packetBytes;
    }

    @Override
    public void clearAllRawPackets() {
        this.clearRawPacket();
        this.getPacket().clearAllRawPackets();
    }

    public void clearPacketBytes() {
        this.packetBytes = null;
    }

    @Override
    public EthernetPacket copy() {
        EthernetPacket ret = new EthernetPacket();
        ret.dst = this.dst;
        ret.src = this.src;
        ret.vlan = this.vlan == -2 ? -1 : this.vlan;
        ret.type = this.type;
        ret.packet = this.packet.copy();
        ret.packet.recordParent(ret);
        return ret;
    }

    @Override
    public String description() {
        return "ether,dl_dst=" + this.dst + ",dl_src=" + this.src + (String)(this.vlan >= 0 ? ",vlan=" + this.vlan : "") + "," + this.packet.description();
    }

    public String toString() {
        return "EthernetPacket{dst=" + this.dst + ", src=" + this.src + ", type=" + Utils.toHexString(this.type) + (String)(this.vlan >= 0 ? ", vlan=" + this.vlan : "") + ", packet=" + this.packet + "}";
    }

    public MacAddress getSrc() {
        return this.src;
    }

    public void setSrc(MacAddress src) {
        if (this.raw != null) {
            for (int i = 0; i < src.bytes.length(); ++i) {
                this.raw.pktBuf.set(6 + i, src.bytes.get(i));
            }
        }
        this.src = src;
    }

    public MacAddress getDst() {
        return this.dst;
    }

    public void setDst(MacAddress dst) {
        if (this.raw != null) {
            for (int i = 0; i < dst.bytes.length(); ++i) {
                this.raw.pktBuf.set(i, dst.bytes.get(i));
            }
        }
        this.dst = dst;
    }

    public int getVlan() {
        return this.vlan;
    }

    public void setVlan(int vlan) {
        if (this.raw != null) {
            if (vlan < 0) {
                if ((this.vlan >= 0 || this.vlan == -2) && vlan != -2) {
                    this.returnHeadroomAndMove(4, 12);
                    this.raw.pktBuf.int16(12, this.type);
                }
            } else if (this.vlan < 0 && this.vlan != -2) {
                if (this.consumeHeadroomAndMove(4, 12)) {
                    this.raw.pktBuf.int16(12, 33024);
                    this.raw.pktBuf.int16(14, vlan);
                    this.raw.pktBuf.int16(16, this.type);
                } else {
                    this.clearRawPacket();
                }
            } else {
                this.raw.pktBuf.int16(14, vlan);
            }
        }
        this.vlan = vlan;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.clearRawPacket();
        this.type = type;
    }

    public AbstractPacket getPacket() {
        return this.packet;
    }

    public void setPacket(AbstractPacket packet) {
        this.clearRawPacket();
        this.packet = packet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EthernetPacket that = (EthernetPacket)o;
        return this.type == that.type && Objects.equals(this.dst, that.dst) && Objects.equals(this.src, that.src) && this.vlan == that.vlan && Objects.equals(this.packet, that.packet);
    }

    public int hashCode() {
        return Objects.hash(this.dst, this.src, this.type, this.packet);
    }
}

