/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.Ipv6Packet;
import io.vproxy.vpacket.PacketDataBuffer;
import io.vproxy.vpacket.PartialPacket;
import java.util.Objects;

public class IcmpPacket
extends AbstractPacket
implements PartialPacket {
    private int type;
    private int code;
    private int checksum;
    private ByteArray other;
    private final boolean isIpv6;

    public IcmpPacket(boolean isIpv6) {
        this.isIpv6 = isIpv6;
    }

    @Override
    public String initPartial(PacketDataBuffer raw) {
        this.raw = raw;
        this.type = raw.pktBuf.uint8(0);
        return null;
    }

    @Override
    public String initPartial(int level) {
        return null;
    }

    @Override
    public String from(PacketDataBuffer raw) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 8) {
            return "input packet length too short for a icmp packet";
        }
        this.type = bytes.uint8(0);
        this.code = bytes.uint8(1);
        this.checksum = bytes.uint16(2);
        this.other = bytes.sub(4, bytes.length() - 4);
        this.raw = raw;
        return null;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        if (this.isIpv6) {
            throw new UnsupportedOperationException("this packet is ICMPv6");
        }
        ByteArray ret = ByteArray.allocate(4).set(0, (byte)this.type).set(1, (byte)this.code).concat(this.other);
        if ((flags & 1) == 0) {
            this.checksum = Utils.calculateChecksum(ret, ret.length());
            ret.int16(2, this.checksum);
            this.checksumCalculated();
        } else {
            this.checksumSkipped();
        }
        return ret;
    }

    @Override
    protected void __updateChecksum() {
        if (this.isIpv6) {
            throw new UnsupportedOperationException("this packet is ICMPv6");
        }
        ByteArray buf = this.raw.pktBuf;
        buf.int16(2, 0);
        int csum = Utils.calculateChecksum(buf, buf.length());
        buf.int16(2, csum);
        this.checksum = csum;
    }

    @Override
    protected void __updateChildrenChecksum() {
    }

    @Override
    public IcmpPacket copy() {
        IcmpPacket ret = new IcmpPacket(this.isIpv6);
        ret.type = this.type;
        ret.code = this.code;
        ret.checksum = this.checksum;
        ret.other = this.other;
        return ret;
    }

    @Override
    public String description() {
        return this.isIpv6 ? "icmp6" : "icmp";
    }

    public ByteArray getRawICMPv6Packet(Ipv6Packet ipv6, int flags) {
        if (!this.isIpv6) {
            throw new UnsupportedOperationException("this packet is ICMP, not v6");
        }
        if (this.raw == null) {
            this.raw = new PacketDataBuffer(this.buildICMPv6Packet(ipv6, flags));
        }
        return this.raw.pktBuf;
    }

    private ByteArray buildICMPv6Packet(Ipv6Packet ipv6, int flags) {
        if (!this.isIpv6) {
            throw new UnsupportedOperationException("this packet is ICMP, not v6");
        }
        ByteArray ret = ByteArray.allocate(4).set(0, (byte)this.type).set(1, (byte)this.code).concat(this.other);
        ByteArray pseudoHeader = Utils.buildPseudoIPv6Header(ipv6, 58, ret.length());
        if ((flags & 1) == 0) {
            ByteArray toCalculate = pseudoHeader.concat(ret);
            this.checksum = Utils.calculateChecksum(toCalculate, toCalculate.length());
            ret.int16(2, this.checksum);
            this.checksumCalculated();
        } else {
            this.checksumSkipped();
        }
        return ret;
    }

    protected void updateChecksumWithIPv6(Ipv6Packet ipv6) {
        if (!this.isIpv6) {
            throw new UnsupportedOperationException("this packet is ICMP, not v6");
        }
        this.raw.pktBuf.int16(2, 0);
        ByteArray pseudoHeader = Utils.buildPseudoIPv6Header(ipv6, 58, this.raw.pktBuf.length());
        ByteArray toCalculate = pseudoHeader.concat(this.raw.pktBuf);
        this.checksum = Utils.calculateChecksum(toCalculate, toCalculate.length());
        this.raw.pktBuf.int16(2, this.checksum);
        this.checksumCalculated();
    }

    public String toString() {
        return "IcmpPacket{type=" + this.type + ", code=" + this.code + ", checksum=" + this.checksum + ", other=" + this.other + "}";
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.clearRawPacket();
        this.type = type;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.clearRawPacket();
        this.code = code;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setChecksum(int checksum) {
        this.clearRawPacket();
        this.checksum = checksum;
    }

    public ByteArray getOther() {
        return this.other;
    }

    public void setOther(ByteArray other) {
        this.clearRawPacket();
        this.other = other;
    }

    public boolean isIpv6() {
        return this.isIpv6;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcmpPacket that = (IcmpPacket)o;
        return this.type == that.type && this.code == that.code && this.checksum == that.checksum && Objects.equals(this.other, that.other) && this.isIpv6 == that.isIpv6;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.code, this.checksum, this.other, this.isIpv6);
    }
}

