/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.Utils;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPv4;
import io.vproxy.vpacket.AbstractIpPacket;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.EtherIPPacket;
import io.vproxy.vpacket.IcmpPacket;
import io.vproxy.vpacket.PacketBytes;
import io.vproxy.vpacket.PacketDataBuffer;
import io.vproxy.vpacket.PartialPacket;
import io.vproxy.vpacket.TcpPacket;
import io.vproxy.vpacket.UdpPacket;
import java.util.Objects;

public class Ipv4Packet
extends AbstractIpPacket {
    private int version;
    private int ihl;
    private int dscp;
    private int ecn;
    private int totalLength;
    private int identification;
    private int flags;
    private int fragmentOffset;
    private int ttl;
    private int protocol;
    private int headerChecksum;
    private IPv4 src;
    private IPv4 dst;
    private ByteArray options = ByteArray.allocate(0);
    private AbstractPacket packet;

    @Override
    public String initPartial(PacketDataBuffer raw) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 20) {
            return "input packet length too short for an ip packet";
        }
        int versionAndIHL = bytes.uint8(0);
        this.ihl = versionAndIHL & 0xF;
        if (bytes.length() < this.ihl * 4) {
            return "input packet smaller than ihl(" + this.ihl + ") specified";
        }
        if (this.ihl < 5) {
            return "input packet ihl(" + this.ihl + ") < 5";
        }
        this.totalLength = bytes.uint16(2);
        if (this.totalLength < this.ihl * 4) {
            return "input ihl(" + this.ihl + ") > totalLength(" + this.totalLength + ")";
        }
        if (this.totalLength > bytes.length()) {
            return "totalLength(" + this.totalLength + ") > input.length(" + bytes.length() + ")";
        }
        this.protocol = bytes.uint8(9);
        ByteArray srcBytes = bytes.sub(12, 4);
        this.src = IP.fromIPv4(srcBytes.toJavaArray());
        ByteArray dstBytes = bytes.sub(16, 4);
        this.dst = IP.fromIPv4(dstBytes.toJavaArray());
        String err = this.initUpperLayerPacket(raw.sub(this.ihl * 4, this.totalLength - this.ihl * 4));
        if (err != null) {
            return err;
        }
        this.ttl = bytes.uint8(8);
        this.raw = raw;
        return null;
    }

    @Override
    public String initPartial(int level) {
        if (this.packet instanceof PartialPacket) {
            return ((PartialPacket)((Object)this.packet)).initPartial(level);
        }
        return null;
    }

    @Override
    public String from(PacketDataBuffer raw) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 20) {
            return "input packet length too short for an ip packet";
        }
        int versionAndIHL = bytes.uint8(0);
        this.version = versionAndIHL >> 4 & 0xFF;
        if (this.version != 4) {
            return "invalid version for ipv4 packet: " + this.version;
        }
        this.ihl = versionAndIHL & 0xF;
        if (bytes.length() < this.ihl * 4) {
            return "input packet smaller than ihl(" + this.ihl + ") specified";
        }
        if (this.ihl < 5) {
            return "input packet ihl(" + this.ihl + ") < 5";
        }
        int dscpAndECN = bytes.uint8(1);
        this.dscp = dscpAndECN >> 2 & 0xFF;
        this.ecn = dscpAndECN & 3;
        this.totalLength = bytes.uint16(2);
        if (this.totalLength < this.ihl * 4) {
            return "input ihl(" + this.ihl + ") > totalLength(" + this.totalLength + ")";
        }
        if (this.totalLength < bytes.length()) {
            assert (Logger.lowLevelDebug("ipv4 packet is cut shorter from " + bytes.length() + " to " + this.totalLength));
            this.setPktBufLen(raw, this.totalLength);
            bytes = raw.pktBuf;
        } else if (this.totalLength > bytes.length()) {
            return "totalLength(" + this.totalLength + ") > input.length(" + bytes.length() + ")";
        }
        this.identification = bytes.uint16(4);
        byte flagsAndFragmentOffsetFirstByte = bytes.get(6);
        this.flags = flagsAndFragmentOffsetFirstByte >> 5 & 0xFF;
        int fragmentOffsetFirstByte = flagsAndFragmentOffsetFirstByte & 0x1F;
        byte fragmentOffsetSecondByte = bytes.get(7);
        this.fragmentOffset = fragmentOffsetFirstByte << 8 | fragmentOffsetSecondByte;
        this.ttl = bytes.uint8(8);
        this.protocol = bytes.uint8(9);
        this.headerChecksum = bytes.uint16(10);
        ByteArray srcBytes = bytes.sub(12, 4);
        this.src = IP.fromIPv4(srcBytes.toJavaArray());
        ByteArray dstBytes = bytes.sub(16, 4);
        this.dst = IP.fromIPv4(dstBytes.toJavaArray());
        this.options = this.ihl > 5 ? bytes.sub(20, this.ihl * 4 - 20) : ByteArray.allocate(0);
        PacketDataBuffer bytesForPacket = raw.sub(this.ihl * 4, this.totalLength - this.ihl * 4);
        this.initUpperLayerPacket(null);
        String err = this.packet.from(bytesForPacket);
        if (err != null) {
            return err;
        }
        this.raw = raw;
        return null;
    }

    private String initUpperLayerPacket(PacketDataBuffer raw) {
        String err;
        if (this.packet != null) {
            return null;
        }
        this.packet = this.protocol == 1 ? new IcmpPacket(false) : (this.protocol == 6 ? new TcpPacket() : (this.protocol == 17 ? new UdpPacket() : (this.protocol == 97 ? new EtherIPPacket() : new PacketBytes())));
        if (raw != null && this.packet instanceof PartialPacket && (err = ((PartialPacket)((Object)this.packet)).initPartial(raw)) != null) {
            return err;
        }
        this.packet.recordParent(this);
        return null;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        int headerLen = 20 + this.options.length();
        if (headerLen % 4 != 0) {
            throw new IllegalArgumentException("header length % 4 != 0: " + headerLen);
        }
        this.ihl = headerLen / 4;
        if (this.packet.raw == null) {
            if (this.packet instanceof TcpPacket) {
                ((TcpPacket)this.packet).buildIPv4TcpPacket(this, flags);
            } else if (this.packet instanceof UdpPacket) {
                ((UdpPacket)this.packet).buildIPv4UdpPacket(this, flags);
            }
        } else if ((flags & 1) == 0) {
            if (this.packet instanceof TcpPacket) {
                ((TcpPacket)this.packet).updateChecksumWithIPv4(this);
            } else if (this.packet instanceof UdpPacket) {
                ((UdpPacket)this.packet).updateChecksumWithIPv4(this);
            }
        }
        ByteArray packetByteArray = this.packet.getRawPacket(flags);
        this.totalLength = headerLen + packetByteArray.length();
        ByteArray arr = this.genHeaderWithChecksumUnfilled().concat(packetByteArray);
        if ((flags & 1) == 0) {
            this.headerChecksum = this.calculateChecksum(arr);
            arr.int16(10, this.headerChecksum);
            this.checksumCalculated();
        } else {
            this.checksumSkipped();
        }
        return arr;
    }

    @Override
    protected void __updateChecksum() {
        int cksum;
        this.raw.pktBuf.int16(10, 0);
        this.headerChecksum = cksum = this.calculateChecksum(this.raw.pktBuf);
        this.raw.pktBuf.int16(10, cksum);
        this.__updateChildrenChecksum();
    }

    @Override
    protected void __updateChildrenChecksum() {
        if (this.packet instanceof TcpPacket) {
            if (this.packet.isRequireUpdatingChecksum()) {
                ((TcpPacket)this.packet).updateChecksumWithIPv4(this);
            }
        } else if (this.packet instanceof UdpPacket) {
            if (this.packet.isRequireUpdatingChecksum()) {
                ((UdpPacket)this.packet).updateChecksumWithIPv4(this);
            } else {
                this.packet.__updateChildrenChecksum();
            }
        } else {
            this.packet.updateChecksum();
        }
    }

    private void pseudoHeaderChanges() {
        if (this.packet instanceof TcpPacket || this.packet instanceof UdpPacket) {
            this.packet.checksumSkipped();
        }
    }

    @Override
    public Ipv4Packet copy() {
        Ipv4Packet ret = new Ipv4Packet();
        ret.version = this.version;
        ret.ihl = this.ihl;
        ret.dscp = this.dscp;
        ret.ecn = this.ecn;
        ret.totalLength = this.totalLength;
        ret.identification = this.identification;
        ret.flags = this.flags;
        ret.fragmentOffset = this.fragmentOffset;
        ret.ttl = this.ttl;
        ret.protocol = this.protocol;
        ret.headerChecksum = this.headerChecksum;
        ret.src = this.src;
        ret.dst = this.dst;
        ret.options = this.options;
        ret.packet = this.packet.copy();
        ret.packet.recordParent(ret);
        return ret;
    }

    @Override
    public void swapSrcDst() {
        IPv4 dst = this.getDst();
        this.setDst(this.getSrc());
        this.setSrc(dst);
    }

    @Override
    public String description() {
        return "ip,nw_src=" + (this.src == null ? "not-parsed-yet" : this.src.formatToIPString()) + ",nw_dst=" + (this.dst == null ? "not-parsed-yet" : this.dst.formatToIPString()) + "," + (this.packet == null ? "not-parsed-yet" : this.packet.description());
    }

    private ByteArray genHeaderWithChecksumUnfilled() {
        byte flagsAndFragmentOffsetFirstByte = (byte)(this.flags << 5 & 0xFF | this.fragmentOffset >> 8 & 0xFF);
        return ByteArray.allocate(6).set(0, (byte)(this.version << 4 | this.ihl)).set(1, (byte)(this.dscp << 2 | this.ecn)).int16(2, this.totalLength).int16(4, this.identification).concat(ByteArray.allocate(6).set(0, flagsAndFragmentOffsetFirstByte).set(1, (byte)this.fragmentOffset).set(2, (byte)this.ttl).set(3, (byte)this.protocol)).concat(this.src.bytes.copy()).concat(this.dst.bytes.copy()).concat(this.options);
    }

    public int calculateChecksum() {
        return this.calculateChecksum(this.genHeaderWithChecksumUnfilled());
    }

    private int calculateChecksum(ByteArray arr) {
        return Utils.calculateChecksum(arr, this.ihl * 4);
    }

    public String toString() {
        return "Ipv4Packet{version=" + this.version + ", ihl=" + this.ihl + ", dscp=" + this.dscp + ", ecn=" + this.ecn + ", totalLength=" + this.totalLength + ", identification=" + this.identification + ", flags=" + this.flags + ", fragmentOffset=" + this.fragmentOffset + ", ttl=" + this.ttl + ", protocol=" + this.protocol + ", headerChecksum=" + this.headerChecksum + ", src=" + this.src + ", dst=" + this.dst + ", options=" + this.options + ", packet=" + this.packet + "}";
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.clearRawPacket();
        this.version = version;
    }

    public int getIhl() {
        return this.ihl;
    }

    public void setIhl(int ihl) {
        this.clearRawPacket();
        this.ihl = ihl;
    }

    public int getDscp() {
        return this.dscp;
    }

    public void setDscp(int dscp) {
        this.clearRawPacket();
        this.dscp = dscp;
    }

    public int getEcn() {
        return this.ecn;
    }

    public void setEcn(int ecn) {
        this.clearRawPacket();
        this.ecn = ecn;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(int totalLength) {
        this.clearRawPacket();
        this.totalLength = totalLength;
    }

    public int getIdentification() {
        return this.identification;
    }

    public void setIdentification(int identification) {
        this.clearRawPacket();
        this.identification = identification;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.clearRawPacket();
        this.flags = flags;
    }

    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    public void setFragmentOffset(int fragmentOffset) {
        this.clearRawPacket();
        this.fragmentOffset = fragmentOffset;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        if (this.raw != null) {
            this.raw.pktBuf.set(8, (byte)ttl);
            this.checksumSkipped();
        }
        this.ttl = ttl;
    }

    @Override
    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.clearRawPacket();
        this.protocol = protocol;
    }

    public int getHeaderChecksum() {
        return this.headerChecksum;
    }

    public void setHeaderChecksum(int headerChecksum) {
        this.clearRawPacket();
        this.headerChecksum = headerChecksum;
    }

    @Override
    public IPv4 getSrc() {
        return this.src;
    }

    public void setSrc(IPv4 src) {
        if (this.raw != null) {
            for (int i = 0; i < 4; ++i) {
                this.raw.pktBuf.set(12 + i, src.getAddress()[i]);
            }
            this.checksumSkipped();
        }
        this.pseudoHeaderChanges();
        this.src = src;
    }

    @Override
    public IPv4 getDst() {
        return this.dst;
    }

    public void setDst(IPv4 dst) {
        if (this.raw != null) {
            for (int i = 0; i < 4; ++i) {
                this.raw.pktBuf.set(16 + i, dst.getAddress()[i]);
            }
            this.checksumSkipped();
        }
        this.pseudoHeaderChanges();
        this.dst = dst;
    }

    public ByteArray getOptions() {
        return this.options;
    }

    public void setOptions(ByteArray options) {
        this.clearRawPacket();
        this.options = options;
    }

    @Override
    public AbstractPacket getPacket() {
        return this.packet;
    }

    @Override
    public int getHopLimit() {
        return this.getTtl();
    }

    @Override
    public void setHopLimit(int n) {
        this.setTtl(n);
    }

    @Override
    public void setPacket(AbstractPacket packet) {
        this.clearRawPacket();
        this.packet = packet;
    }

    @Override
    public void setPacket(int protocol, AbstractPacket packet) {
        this.setProtocol(protocol);
        this.setPacket(packet);
    }

    @Override
    public int getHeaderSize() {
        return 20 + (this.options != null ? this.options.length() : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ipv4Packet that = (Ipv4Packet)o;
        return this.version == that.version && this.ihl == that.ihl && this.dscp == that.dscp && this.ecn == that.ecn && this.totalLength == that.totalLength && this.identification == that.identification && this.flags == that.flags && this.fragmentOffset == that.fragmentOffset && this.ttl == that.ttl && this.protocol == that.protocol && this.headerChecksum == that.headerChecksum && Objects.equals(this.src, that.src) && Objects.equals(this.dst, that.dst) && Objects.equals(this.options, that.options) && Objects.equals(this.packet, that.packet);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.ihl, this.dscp, this.ecn, this.totalLength, this.identification, this.flags, this.fragmentOffset, this.ttl, this.protocol, this.headerChecksum, this.src, this.dst, this.options, this.packet);
    }
}

