/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Consts;
import io.vproxy.base.util.Logger;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPv6;
import io.vproxy.vpacket.AbstractIpPacket;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.EtherIPPacket;
import io.vproxy.vpacket.IcmpPacket;
import io.vproxy.vpacket.PacketBytes;
import io.vproxy.vpacket.PacketDataBuffer;
import io.vproxy.vpacket.PartialPacket;
import io.vproxy.vpacket.TcpPacket;
import io.vproxy.vpacket.UdpPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Ipv6Packet
extends AbstractIpPacket {
    private int version;
    private int trafficClass;
    private int flowLabel;
    private int payloadLength;
    private int nextHeader;
    private int hopLimit;
    private IPv6 src;
    private IPv6 dst;
    private List<ExtHeader> extHeaders = Collections.emptyList();
    private AbstractPacket packet;

    @Override
    public String initPartial(PacketDataBuffer raw) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 40) {
            return "input packet length too short for an ipv6 packet";
        }
        this.nextHeader = bytes.uint8(6);
        if (Consts.IPv6_needs_next_header.contains(this.nextHeader)) {
            return this.from(raw);
        }
        this.extHeaders = Collections.emptyList();
        this.payloadLength = bytes.uint16(4);
        if (this.payloadLength == 0) {
            return "we do not support Jumbo Payload for now";
        }
        if (40 + this.payloadLength > bytes.length()) {
            return "40+payloadLength(" + this.payloadLength + ") > input.length(" + bytes.length() + ")";
        }
        ByteArray srcBytes = bytes.sub(8, 16);
        ByteArray dstBytes = bytes.sub(24, 16);
        this.src = IP.fromIPv6(srcBytes.toJavaArray());
        this.dst = IP.fromIPv6(dstBytes.toJavaArray());
        String err = this.initUpperLayerPacket(this.nextHeader, raw.sub(40, this.payloadLength));
        if (err != null) {
            return err;
        }
        this.hopLimit = bytes.uint8(7);
        this.raw = raw;
        return null;
    }

    @Override
    public String initPartial(int level) {
        if (this.packet instanceof PartialPacket) {
            return ((PartialPacket)((Object)this.packet)).initPartial(level);
        }
        return null;
    }

    @Override
    public String from(PacketDataBuffer raw) {
        return this.from(raw, true);
    }

    public String from(PacketDataBuffer raw, boolean mustParse) {
        ByteArray bytes = raw.pktBuf;
        if (raw == this.raw && this.version != 0 && !mustParse) {
            return null;
        }
        if (bytes.length() < 40) {
            return "input packet length too short for an ipv6 packet";
        }
        byte b0 = bytes.get(0);
        byte b1 = bytes.get(1);
        int version = b0 >> 4 & 0xF;
        this.trafficClass = b0 << 4 & 0xF0 | b1 >> 4 & 0xF;
        this.flowLabel = (b1 & 0xF) << 16 | bytes.uint16(2);
        if (version != 6) {
            return "invalid version for ipv6 packet: " + version;
        }
        this.payloadLength = bytes.uint16(4);
        this.nextHeader = bytes.uint8(6);
        this.hopLimit = bytes.uint8(7);
        if (this.payloadLength == 0) {
            return "we do not support Jumbo Payload for now";
        }
        if (40 + this.payloadLength < bytes.length()) {
            assert (Logger.lowLevelDebug("ipv6 packet is cut shorter from " + bytes.length() + " to " + (40 + this.payloadLength)));
            this.setPktBufLen(raw, 40 + this.payloadLength);
            bytes = raw.pktBuf;
        } else if (40 + this.payloadLength > bytes.length()) {
            return "40+payloadLength(" + this.payloadLength + ") > input.length(" + bytes.length() + ")";
        }
        ByteArray srcBytes = bytes.sub(8, 16);
        ByteArray dstBytes = bytes.sub(24, 16);
        this.src = IP.fromIPv6(srcBytes.toJavaArray());
        this.dst = IP.fromIPv6(dstBytes.toJavaArray());
        int skipLengthForExtHeaders = 0;
        this.extHeaders = new ArrayList<ExtHeader>();
        if (Consts.IPv6_needs_next_header.contains(this.nextHeader)) {
            int xh = this.nextHeader;
            ByteArray xhBuf = bytes.sub(40, bytes.length() - 40);
            while (Consts.IPv6_needs_next_header.contains(xh)) {
                ExtHeader h = new ExtHeader();
                String err = h.from(xhBuf);
                if (err != null) {
                    return err;
                }
                h.recordParent(this);
                this.extHeaders.add(h);
                xh = h.nextHeader;
                int len = h.getRawPacket(0).length();
                if (xhBuf.length() < len) {
                    return "invalid packet length too short for next header";
                }
                skipLengthForExtHeaders += len;
                xhBuf = xhBuf.sub(0, len);
            }
        }
        PacketDataBuffer bytesForPacket = raw.sub(40 + skipLengthForExtHeaders, bytes.length() - 40 - skipLengthForExtHeaders);
        int protocol = this.nextHeader;
        if (!this.extHeaders.isEmpty()) {
            protocol = this.extHeaders.get((int)(this.extHeaders.size() - 1)).nextHeader;
        }
        if (protocol == 59 && bytesForPacket.pktBuf.length() != 0) {
            return "invalid packet: getting next header " + protocol + "(NO_NEXT_HEADER) but the input bytes length for next packet is not 0";
        }
        this.initUpperLayerPacket(protocol, null);
        String err = this.packet.from(bytesForPacket);
        if (err != null) {
            return err;
        }
        this.version = version;
        this.raw = raw;
        return null;
    }

    private String initUpperLayerPacket(int protocol, PacketDataBuffer raw) {
        String err;
        if (this.packet != null) {
            return null;
        }
        this.packet = protocol == 1 || protocol == 58 ? new IcmpPacket(protocol == 58) : (protocol == 6 ? new TcpPacket() : (protocol == 17 ? new UdpPacket() : (protocol == 97 ? new EtherIPPacket() : new PacketBytes())));
        if (raw != null && this.packet instanceof PartialPacket && (err = ((PartialPacket)((Object)this.packet)).initPartial(raw)) != null) {
            return err;
        }
        this.packet.recordParent(this);
        return null;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        byte b0 = (byte)(this.version << 4 | this.trafficClass >> 4 & 0xF);
        byte b1 = (byte)(this.trafficClass << 4 | this.flowLabel >> 16 & 0xF);
        ByteArray headers = ByteArray.allocate(8).set(0, b0).set(1, b1).int16(2, this.flowLabel).int16(4, this.payloadLength).set(6, (byte)this.nextHeader).set(7, (byte)this.hopLimit).concat(this.src.bytes.copy()).concat(this.dst.bytes.copy());
        for (ExtHeader h : this.extHeaders) {
            headers = headers.concat(h.getRawPacket(flags));
        }
        if (this.packet.raw == null) {
            if (this.packet instanceof IcmpPacket && ((IcmpPacket)this.packet).isIpv6()) {
                ((IcmpPacket)this.packet).getRawICMPv6Packet(this, flags);
            } else if (this.packet instanceof TcpPacket) {
                ((TcpPacket)this.packet).buildIPv6TcpPacket(this, flags);
            } else if (this.packet instanceof UdpPacket) {
                ((UdpPacket)this.packet).buildIPv6UdpPacket(this, flags);
            }
        } else if ((flags & 1) == 0) {
            if (this.packet instanceof IcmpPacket && ((IcmpPacket)this.packet).isIpv6()) {
                ((IcmpPacket)this.packet).updateChecksumWithIPv6(this);
            } else if (this.packet instanceof TcpPacket) {
                ((TcpPacket)this.packet).updateChecksumWithIPv6(this);
            } else if (this.packet instanceof UdpPacket) {
                ((UdpPacket)this.packet).updateChecksumWithIPv6(this);
            }
        }
        return headers.concat(this.packet.getRawPacket(flags));
    }

    @Override
    protected void __updateChecksum() {
        this.__updateChildrenChecksum();
    }

    @Override
    protected void __updateChildrenChecksum() {
        if (this.packet instanceof IcmpPacket && ((IcmpPacket)this.packet).isIpv6()) {
            if (this.packet.isRequireUpdatingChecksum()) {
                ((IcmpPacket)this.packet).updateChecksumWithIPv6(this);
            }
        } else if (this.packet instanceof TcpPacket) {
            if (this.packet.isRequireUpdatingChecksum()) {
                ((TcpPacket)this.packet).updateChecksumWithIPv6(this);
            }
        } else if (this.packet instanceof UdpPacket) {
            if (this.packet.isRequireUpdatingChecksum()) {
                ((UdpPacket)this.packet).updateChecksumWithIPv6(this);
            }
        } else {
            this.packet.updateChecksum();
        }
    }

    private void pseudoHeaderChanges() {
        if (this.packet instanceof IcmpPacket || this.packet instanceof TcpPacket || this.packet instanceof UdpPacket) {
            this.packet.checksumSkipped();
        }
    }

    @Override
    public Ipv6Packet copy() {
        Ipv6Packet ret = new Ipv6Packet();
        ret.version = this.version;
        ret.trafficClass = this.trafficClass;
        ret.flowLabel = this.flowLabel;
        ret.payloadLength = this.payloadLength;
        ret.nextHeader = this.nextHeader;
        ret.hopLimit = this.hopLimit;
        ret.src = this.src;
        ret.dst = this.dst;
        ret.extHeaders = new ArrayList<ExtHeader>(this.extHeaders.size());
        for (ExtHeader h : this.extHeaders) {
            ExtHeader x = h.copy();
            ret.extHeaders.add(x);
            x.recordParent(ret);
        }
        ret.packet = this.packet.copy();
        ret.packet.recordParent(ret);
        return ret;
    }

    @Override
    public void swapSrcDst() {
        IPv6 dst = this.getDst();
        this.setDst(this.getSrc());
        this.setSrc(dst);
    }

    @Override
    public void clearAllRawPackets() {
        super.clearAllRawPackets();
        for (ExtHeader h : this.extHeaders) {
            h.clearAllRawPackets();
        }
    }

    @Override
    public String description() {
        return "ipv6,ipv6_src=" + (this.src == null ? "not-parsed-yet" : this.src.formatToIPString()) + ",ipv6_dst=" + (this.dst == null ? "not-parsed-yet" : this.dst.formatToIPString()) + "," + (this.packet == null ? "not-parsed-yet" : this.packet.description());
    }

    public String toString() {
        return "Ipv6Packet{version=" + this.version + ", trafficClass=" + this.trafficClass + ", flowLabel=" + this.flowLabel + ", payloadLength=" + this.payloadLength + ", nextHeader=" + this.nextHeader + ", hopLimit=" + this.hopLimit + ", src=" + this.src + ", dst=" + this.dst + ", extHeaders=" + this.extHeaders + ", packet=" + this.packet + "}";
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.clearRawPacket();
        this.version = version;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.clearRawPacket();
        this.trafficClass = trafficClass;
    }

    public int getFlowLabel() {
        return this.flowLabel;
    }

    public void setFlowLabel(int flowLabel) {
        this.clearRawPacket();
        this.flowLabel = flowLabel;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public void setPayloadLength(int payloadLength) {
        this.clearRawPacket();
        this.payloadLength = payloadLength;
    }

    public int getNextHeader() {
        return this.nextHeader;
    }

    public void setNextHeader(int nextHeader) {
        this.clearRawPacket();
        this.nextHeader = nextHeader;
    }

    @Override
    public int getHopLimit() {
        return this.hopLimit;
    }

    @Override
    public void setHopLimit(int hopLimit) {
        if (this.raw != null) {
            this.raw.pktBuf.set(7, (byte)hopLimit);
        }
        this.hopLimit = hopLimit;
    }

    @Override
    public int getProtocol() {
        if (this.extHeaders.isEmpty()) {
            return this.nextHeader;
        }
        return this.extHeaders.get((int)(this.extHeaders.size() - 1)).nextHeader;
    }

    @Override
    public IPv6 getSrc() {
        return this.src;
    }

    public void setSrc(IPv6 src) {
        if (this.raw != null) {
            for (int i = 0; i < 16; ++i) {
                this.raw.pktBuf.set(8 + i, src.getAddress()[i]);
            }
        }
        this.pseudoHeaderChanges();
        this.src = src;
    }

    @Override
    public IPv6 getDst() {
        return this.dst;
    }

    public void setDst(IPv6 dst) {
        if (this.raw != null) {
            for (int i = 0; i < 16; ++i) {
                this.raw.pktBuf.set(24 + i, dst.getAddress()[i]);
            }
        }
        this.pseudoHeaderChanges();
        this.dst = dst;
    }

    public List<ExtHeader> getExtHeaders() {
        return this.extHeaders;
    }

    public void setExtHeaders(List<ExtHeader> extHeaders) {
        this.clearRawPacket();
        this.extHeaders = extHeaders;
    }

    @Override
    public AbstractPacket getPacket() {
        return this.packet;
    }

    @Override
    public void setPacket(AbstractPacket packet) {
        this.clearRawPacket();
        this.packet = packet;
    }

    @Override
    public void setPacket(int protocol, AbstractPacket packet) {
        this.setPacket(packet);
        if (this.extHeaders.isEmpty()) {
            this.nextHeader = protocol;
        } else {
            this.extHeaders.get((int)(this.extHeaders.size() - 1)).nextHeader = protocol;
        }
    }

    @Override
    public int getHeaderSize() {
        int n = 40;
        if (this.extHeaders != null) {
            for (ExtHeader h : this.extHeaders) {
                n += 8;
                n += h.hdrExtLen;
            }
        }
        return n;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ipv6Packet that = (Ipv6Packet)o;
        return this.version == that.version && this.trafficClass == that.trafficClass && this.flowLabel == that.flowLabel && this.payloadLength == that.payloadLength && this.nextHeader == that.nextHeader && this.hopLimit == that.hopLimit && Objects.equals(this.src, that.src) && Objects.equals(this.dst, that.dst) && Objects.equals(this.extHeaders, that.extHeaders) && Objects.equals(this.packet, that.packet);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.trafficClass, this.flowLabel, this.payloadLength, this.nextHeader, this.hopLimit, this.src, this.dst, this.extHeaders, this.packet);
    }

    public static class ExtHeader
    extends AbstractPacket {
        private int nextHeader;
        private int hdrExtLen;
        private ByteArray other;

        @Override
        public String from(PacketDataBuffer raw) {
            throw new UnsupportedOperationException("use from(ByteArray) instead");
        }

        public String from(ByteArray bytes) {
            if (bytes.length() < 8) {
                return "input packet length too short for an ipv6 ext hdr packet";
            }
            this.nextHeader = bytes.uint8(0);
            this.hdrExtLen = bytes.uint8(1);
            if (bytes.length() < 8 + this.hdrExtLen) {
                return "input packet length too short for an ipv6 ext hdr packet";
            }
            this.other = bytes.sub(2, 6 + this.hdrExtLen);
            this.raw = new PacketDataBuffer(bytes.sub(0, 8 + this.hdrExtLen));
            return null;
        }

        @Override
        protected ByteArray buildPacket(int flags) {
            return ByteArray.allocate(2).set(0, (byte)this.nextHeader).set(1, (byte)this.hdrExtLen).concat(this.other);
        }

        @Override
        protected void __updateChecksum() {
        }

        @Override
        protected void __updateChildrenChecksum() {
        }

        @Override
        public ExtHeader copy() {
            ExtHeader ret = new ExtHeader();
            ret.nextHeader = this.nextHeader;
            ret.hdrExtLen = this.hdrExtLen;
            ret.other = this.other;
            return ret;
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "ExtHeader{nextHeader=" + this.nextHeader + ", hdrExtLen=" + this.hdrExtLen + ", other=" + this.other + "}";
        }

        public int getNextHeader() {
            return this.nextHeader;
        }

        public void setNextHeader(int nextHeader) {
            this.clearRawPacket();
            this.nextHeader = nextHeader;
        }

        public int getHdrExtLen() {
            return this.hdrExtLen;
        }

        public void setHdrExtLen(int hdrExtLen) {
            this.clearRawPacket();
            this.hdrExtLen = hdrExtLen;
        }

        public ByteArray getOther() {
            return this.other;
        }

        public void setOther(ByteArray other) {
            this.clearRawPacket();
            this.other = other;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtHeader extHeader = (ExtHeader)o;
            return this.nextHeader == extHeader.nextHeader && this.hdrExtLen == extHeader.hdrExtLen && Objects.equals(this.other, extHeader.other);
        }

        public int hashCode() {
            return Objects.hash(this.nextHeader, this.hdrExtLen, this.other);
        }
    }
}

