/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.ArpPacket;
import io.vproxy.vpacket.Ipv4Packet;
import io.vproxy.vpacket.Ipv6Packet;
import io.vproxy.vpacket.PacketBytes;
import io.vproxy.vpacket.PacketDataBuffer;

public class LinuxCookedPacket
extends AbstractPacket {
    private int type;
    private int addrType;
    private int addrLen;
    private ByteArray addr;
    private int proto;
    private AbstractPacket payload;
    public static final int TYPE_RCV = 0;
    public static final int TYPE_BROADCAST_RCV = 1;
    public static final int TYPE_MULTICAST_RCV = 2;
    public static final int TYPE_FORWARD = 3;
    public static final int TYPE_SND = 4;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (this.raw != null) {
            this.raw.pktBuf.int16(0, type);
        }
        this.type = type;
    }

    public int getAddrType() {
        return this.addrType;
    }

    public void setAddrType(int addrType) {
        if (this.raw != null) {
            this.raw.pktBuf.int16(2, addrType);
        }
        this.addrType = addrType;
    }

    public int getAddrLen() {
        return this.addrLen;
    }

    public void setAddrLen(int addrLen) {
        if (this.raw != null) {
            this.raw.pktBuf.int16(4, addrLen);
        }
        this.addrLen = addrLen;
    }

    public ByteArray getAddr() {
        return this.addr;
    }

    public void setAddr(ByteArray addr) {
        if (addr.length() > 8) {
            throw new IllegalArgumentException();
        }
        if (addr.length() < 8) {
            addr = addr.concat(ByteArray.allocateInitZero(8 - addr.length()));
        }
        if (this.raw != null) {
            for (int i = 0; i < 8; ++i) {
                this.raw.pktBuf.set(6 + i, addr.get(i));
            }
        }
        this.addr = addr;
    }

    public int getProto() {
        return this.proto;
    }

    public void setProto(int proto) {
        if (this.raw != null) {
            this.raw.pktBuf.int16(14, proto);
        }
        this.proto = proto;
    }

    public AbstractPacket getPayload() {
        return this.payload;
    }

    public void setPayload(AbstractPacket payload) {
        this.clearRawPacket();
        this.payload = payload;
    }

    @Override
    public void clearAllRawPackets() {
        this.clearRawPacket();
        this.getPayload().clearAllRawPackets();
    }

    @Override
    public String from(PacketDataBuffer raw) {
        PacketDataBuffer data;
        if (raw.pktBuf.length() < 16) {
            return "packet too short";
        }
        this.type = raw.pktBuf.uint16(0);
        this.addrType = raw.pktBuf.uint16(2);
        this.addrLen = raw.pktBuf.uint16(4);
        this.addr = raw.pktBuf.sub(6, 8);
        this.proto = raw.pktBuf.uint16(14);
        AbstractPacket packet = this.proto == 2054 ? new ArpPacket() : (this.proto == 2048 ? new Ipv4Packet() : (this.proto == 34525 ? new Ipv6Packet() : new PacketBytes()));
        String err = packet.from(data = raw.sub(16));
        if (err != null) {
            return err;
        }
        packet.recordParent(this);
        this.setPayload(packet);
        this.raw = raw;
        return null;
    }

    @Override
    public AbstractPacket copy() {
        LinuxCookedPacket p = new LinuxCookedPacket();
        p.setType(this.type);
        p.setAddrType(this.addrType);
        p.setAddrLen(this.addrLen);
        p.setAddr(this.addr.copy());
        p.setProto(this.proto);
        p.setPayload(this.payload.copy());
        return p;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        ByteArray b = ByteArray.allocate(16).int16(0, this.type).int16(2, this.addrType).int16(4, this.addrLen).int16(14, this.proto);
        for (int i = 0; i < 8; ++i) {
            b.set(6 + i, this.addr.get(i));
        }
        return b.concat(this.payload.getRawPacket(flags));
    }

    @Override
    protected void __updateChecksum() {
        this.payload.__updateChecksum();
    }

    @Override
    protected void __updateChildrenChecksum() {
        this.payload.__updateChecksum();
    }

    @Override
    public String description() {
        return "type=" + this.typeDesc() + ",l_addr=" + this.addr.toHexString() + "," + this.payload.description();
    }

    private String typeDesc() {
        switch (this.type) {
            case 0: {
                return "rcv";
            }
            case 1: {
                return "broadcast_rcv";
            }
            case 2: {
                return "multicast_rcv";
            }
            case 3: {
                return "forward";
            }
            case 4: {
                return "send";
            }
        }
        return "" + this.type;
    }
}

