/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;

public class PacketDataBuffer {
    public ByteArray fullbuf;
    public int pktOff;
    public int pad;
    public ByteArray pktBuf;

    public PacketDataBuffer(ByteArray fullbuf, int pktOff, int pad) {
        this.fullbuf = fullbuf;
        this.pktOff = pktOff;
        this.pad = pad;
        this.pktBuf = pktOff == 0 && pad == 0 ? fullbuf : fullbuf.sub(pktOff, fullbuf.length() - pktOff - pad);
    }

    public PacketDataBuffer(ByteArray pktBuf) {
        if (pktBuf == null) {
            return;
        }
        this.fullbuf = pktBuf;
        this.pktOff = 0;
        this.pad = 0;
        this.pktBuf = pktBuf;
    }

    public void clearBuffers() {
        this.fullbuf = null;
        this.pktOff = 0;
        this.pad = 0;
        this.pktBuf = null;
    }

    public PacketDataBuffer sub(int off) {
        return new PacketDataBuffer(this.fullbuf, this.pktOff + off, this.pad);
    }

    public PacketDataBuffer sub(int off, int len) {
        return new PacketDataBuffer(this.fullbuf, this.pktOff + off, this.fullbuf.length() - (this.pktOff + off) - len);
    }
}

