/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;

public class PcapGlobalHeader {
    public final int magicNumber;
    public final int versionMajor;
    public final int versionMinor;
    public final int reserved1;
    public final int reserved2;
    public final int snaplen;
    public final int dataLinkType;
    public static final int LINKTYPE_NULL = 0;
    public static final int LINKTYPE_ETHERNET = 1;
    public static final int LINKTYPE_LINUX_SLL = 113;

    public PcapGlobalHeader() {
        this(65536, 1);
    }

    public PcapGlobalHeader(int snaplen, int dataLinkType) {
        this(-1582119980, 2, 4, 0, 0, snaplen, dataLinkType);
    }

    public PcapGlobalHeader(int magicNumber, int versionMajor, int versionMinor, int reserved1, int reserved2, int snaplen, int dataLinkType) {
        this.magicNumber = magicNumber;
        this.versionMajor = versionMajor;
        this.versionMinor = versionMinor;
        this.reserved1 = reserved1;
        this.reserved2 = reserved2;
        this.snaplen = snaplen;
        this.dataLinkType = dataLinkType;
    }

    public ByteArray build() {
        return ByteArray.allocate(24).int32ReverseNetworkByteOrder(0, this.magicNumber).int16ReverseNetworkByteOrder(4, this.versionMajor).int16ReverseNetworkByteOrder(6, this.versionMinor).int32ReverseNetworkByteOrder(8, this.reserved1).int32ReverseNetworkByteOrder(12, this.reserved2).int32ReverseNetworkByteOrder(16, this.snaplen).int32ReverseNetworkByteOrder(20, this.dataLinkType);
    }

    public String toString() {
        return "PcapGlobalHeader{magicNumber=" + Long.toString((long)this.magicNumber & 0xFFFFFFFFL, 16) + ", versionMajor=" + this.versionMajor + ", versionMinor=" + this.versionMinor + ", reserved1(thisZone)=" + this.reserved1 + ", reserved2(sigfigs)=" + this.reserved2 + ", snaplen=" + this.snaplen + ", dataLinkType=" + this.dataLinkType + "}";
    }
}

