/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.vpacket.AbstractPacket;

public class PcapPacket {
    private int tssec;
    private int tsusec;
    private int capLen;
    private int origLen;
    private AbstractPacket packet;

    public PcapPacket() {
    }

    public PcapPacket(AbstractPacket packet) {
        this(System.currentTimeMillis(), packet);
    }

    public PcapPacket(long ts, AbstractPacket packet) {
        this.tssec = (int)(ts / 1000L);
        this.tsusec = (int)(ts % 1000L) * 1000;
        this.packet = packet;
    }

    public PcapPacket(int tssec, int tsusec, int capLen, int origLen) {
        this.tssec = tssec;
        this.tsusec = tsusec;
        this.capLen = capLen;
        this.origLen = origLen;
    }

    public int getTssec() {
        return this.tssec;
    }

    public void setTssec(int tssec) {
        this.tssec = tssec;
    }

    public int getTsusec() {
        return this.tsusec;
    }

    public void setTsusec(int tsusec) {
        this.tsusec = tsusec;
    }

    public int getCapLen() {
        return this.capLen;
    }

    public void setCapLen(int capLen) {
        this.capLen = capLen;
    }

    public int getOrigLen() {
        return this.origLen;
    }

    public void setOrigLen(int origLen) {
        this.origLen = origLen;
    }

    public AbstractPacket getPacket() {
        return this.packet;
    }

    public void setPacket(AbstractPacket packet) {
        this.packet = packet;
    }

    public ByteArray build() {
        ByteArray pkt = this.packet.getRawPacket(0);
        int origLen = this.origLen;
        if (origLen == 0) {
            origLen = pkt.length();
        }
        return ByteArray.allocate(16).int32ReverseNetworkByteOrder(0, this.tssec).int32ReverseNetworkByteOrder(4, this.tsusec).int32ReverseNetworkByteOrder(8, pkt.length()).int32ReverseNetworkByteOrder(12, origLen).concat(pkt);
    }

    public String toString() {
        return "ts=" + Utils.formatTimestampForLogging((long)this.tssec * 1000L + (long)(this.tsusec / 1000)) + "," + this.packet.description();
    }
}

