/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.vpacket.BSDLoopbackEncapsulation;
import io.vproxy.vpacket.EthernetPacket;
import io.vproxy.vpacket.LinuxCookedPacket;
import io.vproxy.vpacket.PacketBytes;
import io.vproxy.vpacket.PacketDataBuffer;
import io.vproxy.vpacket.PcapGlobalHeader;
import io.vproxy.vpacket.PcapPacket;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class PcapParser {
    private final InputStream data;
    private boolean copyPacket = true;
    private byte[] buf = new byte[4096];
    private int state = 0;
    private PcapGlobalHeader globalHeader;

    public PcapParser(String filename) throws FileNotFoundException {
        this(Path.of(filename, new String[0]));
    }

    public PcapParser(Path filepath) throws FileNotFoundException {
        this(filepath.toFile());
    }

    public PcapParser(File file) throws FileNotFoundException {
        this.data = new FileInputStream(file);
    }

    public PcapParser(InputStream data) {
        this.data = data;
    }

    public PcapPacket next() throws IllegalArgumentException, RuntimeException {
        while (this.state == 0) {
            this.readGlobalHeader();
        }
        return this.readPacketHeaderAndPacket();
    }

    public List<PcapPacket> parseAll() throws RuntimeException {
        PcapPacket pkt;
        ArrayList<PcapPacket> result = new ArrayList<PcapPacket>();
        while ((pkt = this.next()) != null) {
            result.add(pkt);
        }
        return result;
    }

    public boolean isCopyPacket() {
        return this.copyPacket;
    }

    public void setCopyPacket(boolean copyPacket) {
        this.copyPacket = copyPacket;
    }

    private void readGlobalHeader() {
        int len = 24;
        ByteArray buf = this.next(len);
        if (buf == null) {
            Logger.error(LogType.INVALID_EXTERNAL_DATA, "unable to read global header: EOF");
            throw new IllegalArgumentException();
        }
        if (buf.length() != len) {
            Logger.error(LogType.INVALID_EXTERNAL_DATA, "unable to read global header: cannot read " + len + " bytes from the stream");
            throw new IllegalArgumentException();
        }
        this.globalHeader = new PcapGlobalHeader(buf.int32ReverseNetworkByteOrder(0), buf.uint16ReverseNetworkByteOrder(4), buf.uint16ReverseNetworkByteOrder(6), buf.int32ReverseNetworkByteOrder(8), buf.int32ReverseNetworkByteOrder(12), buf.int32ReverseNetworkByteOrder(16), buf.int32ReverseNetworkByteOrder(20));
        if (this.globalHeader.snaplen > this.buf.length) {
            this.buf = new byte[this.globalHeader.snaplen];
        }
        this.state = 1;
    }

    private PcapPacket readPacketHeaderAndPacket() {
        ByteArray headerBuf = this.next(16);
        if (headerBuf == null) {
            return null;
        }
        if (headerBuf.length() != 16) {
            Logger.warn(LogType.INVALID_EXTERNAL_DATA, "incomplete packet header, probably tcpdump is interrupted");
            return null;
        }
        PcapPacket pcapPacket = new PcapPacket(headerBuf.int32ReverseNetworkByteOrder(0), headerBuf.int32ReverseNetworkByteOrder(4), headerBuf.int32ReverseNetworkByteOrder(8), headerBuf.int32ReverseNetworkByteOrder(12));
        int len = pcapPacket.getCapLen();
        ByteArray buf = this.next(len);
        if (buf == null) {
            Logger.warn(LogType.INVALID_EXTERNAL_DATA, "no packet data, probably tcpdump is interrupted");
            return null;
        }
        if (buf.length() < len) {
            Logger.warn(LogType.INVALID_EXTERNAL_DATA, "no packet data, probably tcpdump is interrupted, expecting " + len + ", got " + buf.length());
            return null;
        }
        if (this.copyPacket) {
            buf = buf.copy();
        }
        String err = null;
        if (this.globalHeader.dataLinkType == 1) {
            EthernetPacket e = new EthernetPacket();
            err = e.from(new PacketDataBuffer(buf));
            pcapPacket.setPacket(e);
        } else if (this.globalHeader.dataLinkType == 113) {
            LinuxCookedPacket l = new LinuxCookedPacket();
            err = l.from(new PacketDataBuffer(buf));
            pcapPacket.setPacket(l);
        } else if (this.globalHeader.dataLinkType == 0) {
            BSDLoopbackEncapsulation bsd = new BSDLoopbackEncapsulation();
            err = bsd.from(new PacketDataBuffer(buf));
            pcapPacket.setPacket(bsd);
        } else {
            pcapPacket.setPacket(new PacketBytes(buf));
        }
        if (err != null) {
            Logger.warn(LogType.INVALID_EXTERNAL_DATA, "invalid packet: " + err);
            pcapPacket.setPacket(new PacketBytes(buf));
            return pcapPacket;
        }
        return pcapPacket;
    }

    private ByteArray next(int len) {
        int r;
        if (len == 0) {
            throw new IndexOutOfBoundsException("unexpected len = 0");
        }
        if (len > this.buf.length) {
            throw new IndexOutOfBoundsException("unexpected len = " + len + " > buf.length = " + this.buf.length);
        }
        int n = 0;
        do {
            try {
                r = this.data.read(this.buf, n, len - n);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (r != -1) continue;
            if (n != 0) break;
            return null;
        } while ((n += r) < len);
        return ByteArray.from(this.buf).sub(0, n);
    }

    public PcapGlobalHeader getGlobalHeader() {
        if (this.globalHeader == null) {
            this.readGlobalHeader();
        }
        return this.globalHeader;
    }
}

