/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.Ipv4Packet;
import io.vproxy.vpacket.Ipv6Packet;
import io.vproxy.vpacket.PacketDataBuffer;
import io.vproxy.vpacket.TransportPacket;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class TcpPacket
extends TransportPacket {
    private int srcPort;
    private int dstPort;
    private long seqNum;
    private long ackNum;
    private int dataOffset;
    private int flags;
    private int window;
    private int checksum;
    private int urgentPointer;
    private List<TcpOption> options;
    private ByteArray data;

    @Override
    public int getSrcPort() {
        return this.srcPort;
    }

    @Override
    public void setSrcPort(int srcPort) {
        if (this.raw != null) {
            this.raw.pktBuf.int16(0, srcPort);
            this.checksumSkipped();
        }
        this.srcPort = srcPort;
    }

    @Override
    public int getDstPort() {
        return this.dstPort;
    }

    @Override
    public void setDstPort(int dstPort) {
        if (this.raw != null) {
            this.raw.pktBuf.int16(2, dstPort);
            this.checksumSkipped();
        }
        this.dstPort = dstPort;
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(long seqNum) {
        if (this.raw != null) {
            this.raw.pktBuf.int32(4, (int)seqNum);
            this.checksumSkipped();
        }
        this.seqNum = seqNum;
    }

    public long getAckNum() {
        return this.ackNum;
    }

    public void setAckNum(long ackNum) {
        if (this.raw != null) {
            this.raw.pktBuf.int32(8, (int)ackNum);
            this.checksumSkipped();
        }
        this.ackNum = ackNum;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setDataOffset(int dataOffset) {
        this.clearRawPacket();
        this.dataOffset = dataOffset;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        if (this.raw != null) {
            this.raw.pktBuf.int16(12, this.raw.pktBuf.uint16(12) & 0xFFC0 | flags & 0x3F);
            this.checksumSkipped();
        }
        this.flags = flags;
    }

    public int getWindow() {
        return this.window;
    }

    public void setWindow(int window) {
        this.clearRawPacket();
        this.window = window;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setChecksum(int checksum) {
        this.clearRawPacket();
        this.checksum = checksum;
    }

    public int getUrgentPointer() {
        return this.urgentPointer;
    }

    public void setUrgentPointer(int urgentPointer) {
        this.clearRawPacket();
        this.urgentPointer = urgentPointer;
    }

    public List<TcpOption> getOptions() {
        if (this.options == null) {
            this.options = new LinkedList<TcpOption>();
        }
        return this.options;
    }

    public void setOptions(List<TcpOption> options) {
        this.clearRawPacket();
        this.options = options;
    }

    public ByteArray getData() {
        return this.data;
    }

    public void setData(ByteArray data) {
        this.clearRawPacket();
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpPacket tcpPacket = (TcpPacket)o;
        return this.srcPort == tcpPacket.srcPort && this.dstPort == tcpPacket.dstPort && this.seqNum == tcpPacket.seqNum && this.ackNum == tcpPacket.ackNum && this.dataOffset == tcpPacket.dataOffset && this.flags == tcpPacket.flags && this.window == tcpPacket.window && this.checksum == tcpPacket.checksum && this.urgentPointer == tcpPacket.urgentPointer && Objects.equals(this.options, tcpPacket.options) && Objects.equals(this.data, tcpPacket.data);
    }

    public int hashCode() {
        return Objects.hash(this.srcPort, this.dstPort, this.seqNum, this.ackNum, this.dataOffset, this.flags, this.window, this.checksum, this.urgentPointer, this.options, this.data);
    }

    public String toString() {
        return "TcpPacket{srcPort=" + this.srcPort + ", dstPort=" + this.dstPort + ", seqNum=" + this.seqNum + ", ackNum=" + this.ackNum + ", dataOffset=" + this.dataOffset + ", flags=" + this.flags + ", window=" + this.window + ", checksum=" + this.checksum + ", urgentPointer=" + this.urgentPointer + ", options=" + this.options + ", data=" + this.data + "}";
    }

    @Override
    public String initPartial(PacketDataBuffer raw) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 20) {
            return "input packet length too short for a tcp packet";
        }
        this.srcPort = bytes.uint16(0);
        this.dstPort = bytes.uint16(2);
        int dataOffsetReservedFlags = bytes.uint16(12);
        this.flags = dataOffsetReservedFlags & 0x3F;
        this.raw = raw;
        return null;
    }

    @Override
    public String initPartial(int level) {
        ByteArray bytes = this.raw.pktBuf;
        int dataOffsetReservedFlags = bytes.uint16(12);
        this.flags = dataOffsetReservedFlags & 0x3F;
        if (level > 0) {
            this.seqNum = bytes.uint32(4);
            this.ackNum = bytes.uint32(8);
            this.dataOffset = (dataOffsetReservedFlags >> 12 & 0xF) * 4;
            this.window = bytes.uint16(14);
            this.data = bytes.length() > this.dataOffset ? bytes.sub(this.dataOffset, bytes.length() - this.dataOffset) : ByteArray.allocate(0);
        }
        return null;
    }

    @Override
    public String from(PacketDataBuffer raw) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 20) {
            return "input packet length too short for a tcp packet";
        }
        this.srcPort = bytes.uint16(0);
        this.dstPort = bytes.uint16(2);
        this.seqNum = bytes.uint32(4);
        this.ackNum = bytes.uint32(8);
        int dataOffsetReservedFlags = bytes.uint16(12);
        this.dataOffset = (dataOffsetReservedFlags >> 12 & 0xF) * 4;
        this.flags = dataOffsetReservedFlags & 0x3F;
        this.window = bytes.uint16(14);
        this.checksum = bytes.uint16(16);
        this.urgentPointer = bytes.uint16(18);
        if (this.dataOffset > bytes.length()) {
            return "dataOffset too big";
        }
        this.data = bytes.length() > this.dataOffset ? bytes.sub(this.dataOffset, bytes.length() - this.dataOffset) : ByteArray.allocate(0);
        this.options = new LinkedList<TcpOption>();
        if (this.dataOffset > 20) {
            int off = 20;
            while (off < this.dataOffset) {
                byte kind = bytes.get(off);
                if (TcpOption.CASE_1_OPTION_KINDS[kind & 0xFF]) {
                    TcpOption opt = new TcpOption(this);
                    String err = opt.from(ByteArray.from(new byte[]{kind}));
                    if (err != null) {
                        return err;
                    }
                    opt.recordParent(this);
                    this.options.add(opt);
                    ++off;
                    if (opt.kind != 0) continue;
                    break;
                }
                if (off + 1 >= this.dataOffset) {
                    return "invalid tcp option, reaches dataOffset";
                }
                int len = bytes.uint8(off + 1);
                if (off + len > this.dataOffset) {
                    return "invalid tcp option, length is too long";
                }
                TcpOption opt = new TcpOption(this);
                String err = opt.from(bytes.sub(off, len));
                if (err != null) {
                    return err;
                }
                opt.recordParent(this);
                this.options.add(opt);
                off += len;
            }
        }
        this.raw = raw;
        return null;
    }

    public boolean isSyn() {
        return (this.flags & 2) == 2;
    }

    public boolean isAck() {
        return (this.flags & 0x10) == 16;
    }

    public boolean isRst() {
        return (this.flags & 4) == 4;
    }

    public boolean isPsh() {
        return (this.flags & 8) == 8 || this.data != null && this.data.length() > 0;
    }

    public boolean isFin() {
        return (this.flags & 1) == 1;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void __updateChecksum() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void __updateChildrenChecksum() {
    }

    @Override
    public TcpPacket copy() {
        TcpPacket ret = new TcpPacket();
        ret.srcPort = this.srcPort;
        ret.dstPort = this.dstPort;
        ret.seqNum = this.seqNum;
        ret.ackNum = this.ackNum;
        ret.dataOffset = this.dataOffset;
        ret.flags = this.flags;
        ret.window = this.window;
        ret.checksum = this.checksum;
        ret.urgentPointer = this.urgentPointer;
        if (this.options != null) {
            ret.options = new ArrayList<TcpOption>(this.options.size());
            for (TcpOption o : this.options) {
                TcpOption x = o.copy(ret);
                ret.options.add(x);
                x.recordParent(ret);
            }
        }
        ret.data = this.data;
        return ret;
    }

    @Override
    public void clearAllRawPackets() {
        super.clearAllRawPackets();
        if (this.options != null) {
            for (TcpOption opt : this.options) {
                opt.clearAllRawPackets();
            }
        }
    }

    @Override
    public String description() {
        return "tcp,flags=" + this.formatFlagsDesc(this.flags) + ",tp_src=" + (Serializable)(this.srcPort == 0 ? "not-parsed-yet" : Integer.valueOf(this.srcPort)) + ",tp_dst=" + (Serializable)(this.dstPort == 0 ? "not-parsed-yet" : Integer.valueOf(this.dstPort)) + ",data=" + (this.data == null ? 0 : this.data.length());
    }

    private String formatFlagsDesc(int flags) {
        ArrayList<String> flagList = new ArrayList<String>();
        if ((flags & 2) != 0) {
            flagList.add("SYN");
        }
        if ((flags & 8) != 0) {
            flagList.add("PSH");
        }
        if ((flags & 1) != 0) {
            flagList.add("FIN");
        }
        if ((flags & 4) != 0) {
            flagList.add("RST");
        }
        if ((flags & 0x10) != 0) {
            flagList.add("ACK");
        }
        if ((flags & 0x20) != 0) {
            flagList.add("URG");
        }
        return String.join((CharSequence)",", flagList) + "(" + Integer.toBinaryString(flags) + ")";
    }

    private ByteArray buildCommonPart() {
        ByteArray base = ByteArray.allocate(20);
        base.int16(0, this.srcPort);
        base.int16(2, this.dstPort);
        base.int32(4, (int)this.seqNum);
        base.int32(8, (int)this.ackNum);
        base.int16(14, this.window);
        base.int16(18, this.urgentPointer);
        ByteArray optBytes = null;
        if (this.options != null && !this.options.isEmpty()) {
            if (this.options.get((int)(this.options.size() - 1)).kind != 0) {
                TcpOption end = new TcpOption(this);
                end.kind = 0;
                this.options.add(end);
            }
            for (TcpOption o : this.options) {
                ByteArray b = o.getRawPacket(0);
                if (optBytes == null) {
                    optBytes = b;
                    continue;
                }
                optBytes = optBytes.concat(b);
            }
        }
        if (optBytes != null) {
            base = base.concat(optBytes);
        }
        int padding = 0;
        int off = 20;
        if (optBytes != null) {
            int len = optBytes.length();
            int mod = len % 4;
            if (mod != 0) {
                padding = 4 - mod;
            }
            off += len + padding;
        }
        this.dataOffset = off;
        int dataOffsetReservedFlags = this.dataOffset / 4 << 12 | this.flags;
        base.int16(12, dataOffsetReservedFlags);
        if (padding != 0) {
            base = base.concat(ByteArray.allocate(padding));
        }
        if (this.data == null || this.data.length() == 0) {
            return base;
        }
        return base.concat(this.data);
    }

    public ByteArray buildIPv4TcpPacket(Ipv4Packet ipv4, int flags) {
        ByteArray common = this.buildCommonPart();
        ByteArray pseudo = Utils.buildPseudoIPv4Header(ipv4, 6, common.length());
        ByteArray toCalculate = pseudo.concat(common);
        if ((flags & 1) == 0) {
            this.checksum = Utils.calculateChecksum(toCalculate, toCalculate.length());
            common.int16(16, this.checksum);
            this.checksumCalculated();
        } else {
            this.checksumSkipped();
        }
        this.raw = new PacketDataBuffer(common);
        return common;
    }

    protected void updateChecksumWithIPv4(Ipv4Packet ipv4) {
        int cksum;
        this.raw.pktBuf.int16(16, 0);
        ByteArray pseudo = Utils.buildPseudoIPv4Header(ipv4, 6, this.raw.pktBuf.length());
        ByteArray toCalculate = pseudo.concat(this.raw.pktBuf);
        this.checksum = cksum = Utils.calculateChecksum(toCalculate, toCalculate.length());
        this.raw.pktBuf.int16(16, cksum);
        this.checksumCalculated();
    }

    public ByteArray buildIPv6TcpPacket(Ipv6Packet ipv6, int flags) {
        ByteArray common = this.buildCommonPart();
        ByteArray pseudo = Utils.buildPseudoIPv6Header(ipv6, 6, common.length());
        ByteArray toCalculate = pseudo.concat(common);
        if ((flags & 1) == 0) {
            this.checksum = Utils.calculateChecksum(toCalculate, toCalculate.length());
            common.int16(16, this.checksum);
            this.checksumCalculated();
        } else {
            this.checksumSkipped();
        }
        this.raw = new PacketDataBuffer(common);
        return common;
    }

    protected void updateChecksumWithIPv6(Ipv6Packet ipv6) {
        int cksum;
        this.raw.pktBuf.int16(16, 0);
        ByteArray pseudo = Utils.buildPseudoIPv6Header(ipv6, 6, this.raw.pktBuf.length());
        ByteArray toCalculate = pseudo.concat(this.raw.pktBuf);
        this.checksum = cksum = Utils.calculateChecksum(toCalculate, toCalculate.length());
        this.raw.pktBuf.int16(16, cksum);
        this.checksumCalculated();
    }

    public static class TcpOption
    extends AbstractPacket {
        public static final boolean[] CASE_1_OPTION_KINDS = new boolean[256];
        private final TcpPacket tcpPacket;
        private byte kind;
        private int length;
        private ByteArray data;

        public TcpOption(TcpPacket tcp) {
            this.tcpPacket = tcp;
        }

        public byte getKind() {
            return this.kind;
        }

        public void setKind(byte kind) {
            this.clearRawPacket();
            this.kind = kind;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.clearRawPacket();
            this.length = length;
        }

        public ByteArray getData() {
            return this.data;
        }

        public void setData(ByteArray data) {
            if (CASE_1_OPTION_KINDS[this.kind & 0xFF] || data.length() != this.length - 2) {
                this.clearRawPacket();
            } else if (this.raw != null) {
                this.tcpPacket.checksumSkipped();
                for (int i = 0; i < data.length(); ++i) {
                    this.raw.pktBuf.set(2 + i, data.get(i));
                }
            }
            this.data = data;
        }

        public String toString() {
            return "TcpOption{kind=" + this.kind + ", length=" + this.length + ", data=" + this.data + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TcpOption tcpOption = (TcpOption)o;
            return this.kind == tcpOption.kind && this.length == tcpOption.length && Objects.equals(this.data, tcpOption.data);
        }

        public int hashCode() {
            return Objects.hash(this.kind, this.length, this.data);
        }

        @Override
        public String from(PacketDataBuffer raw) {
            throw new UnsupportedOperationException("use from(ByteArray) instead");
        }

        public String from(ByteArray bytes) {
            this.kind = bytes.get(0);
            if (CASE_1_OPTION_KINDS[this.kind & 0xFF]) {
                return null;
            }
            this.length = bytes.uint8(1);
            this.data = bytes.length() > 2 ? bytes.sub(2, bytes.length() - 2) : ByteArray.allocate(0);
            String err = this.check();
            if (err != null) {
                return err;
            }
            this.raw = new PacketDataBuffer(bytes);
            return null;
        }

        private String check() {
            switch (this.kind) {
                case 3: {
                    if (this.length == 3) break;
                    return "invalid tcp option length for kind=window_scale";
                }
                case 2: {
                    if (this.length == 4) break;
                    return "invalid tcp option length for kind=mss";
                }
            }
            return null;
        }

        @Override
        protected ByteArray buildPacket(int flags) {
            if (CASE_1_OPTION_KINDS[this.kind & 0xFF]) {
                return ByteArray.from(new byte[]{this.kind});
            }
            this.length = this.data.length() == 0 ? 2 : 2 + this.data.length();
            ByteArray o = ByteArray.allocate(2);
            o.set(0, this.kind);
            o.set(1, (byte)this.length);
            if (this.data == null) {
                return o;
            }
            return o.concat(this.data);
        }

        @Override
        protected void __updateChecksum() {
        }

        @Override
        protected void __updateChildrenChecksum() {
        }

        @Override
        public TcpOption copy() {
            throw new UnsupportedOperationException();
        }

        public TcpOption copy(TcpPacket tcp) {
            TcpOption ret = new TcpOption(tcp);
            ret.kind = this.kind;
            ret.length = this.length;
            ret.data = this.data;
            return ret;
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        static {
            for (byte b : List.of(Byte.valueOf((byte)0), Byte.valueOf((byte)1))) {
                TcpOption.CASE_1_OPTION_KINDS[b & 0xFF] = true;
            }
        }
    }
}

