/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.Ipv4Packet;
import io.vproxy.vpacket.Ipv6Packet;
import io.vproxy.vpacket.PacketBytes;
import io.vproxy.vpacket.PacketDataBuffer;
import io.vproxy.vpacket.TransportPacket;
import java.util.Objects;

public class UdpPacket
extends TransportPacket {
    private int srcPort;
    private int dstPort;
    private int length;
    private int checksum;
    private AbstractPacket data;

    @Override
    public String initPartial(PacketDataBuffer raw) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 8) {
            return "input packet length too short for an udp packet";
        }
        this.srcPort = bytes.uint16(0);
        this.dstPort = bytes.uint16(2);
        this.raw = raw;
        return null;
    }

    @Override
    public String initPartial(int level) {
        ByteArray bytes = this.raw.pktBuf;
        if (level > 0) {
            PacketBytes pktBytes = new PacketBytes();
            pktBytes.from(new PacketDataBuffer(bytes.sub(8, bytes.length() - 8)));
            this.data = pktBytes;
        }
        return null;
    }

    @Override
    public String from(PacketDataBuffer raw) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 8) {
            return "input packet length too short for an udp packet";
        }
        this.srcPort = bytes.uint16(0);
        this.dstPort = bytes.uint16(2);
        this.length = bytes.uint16(4);
        this.checksum = bytes.uint16(6);
        if (bytes.length() != this.length) {
            return "udp packet length not matching the input bytes length";
        }
        PacketBytes pktBytes = new PacketBytes();
        pktBytes.from(new PacketDataBuffer(bytes.sub(8, bytes.length() - 8)));
        this.data = pktBytes;
        this.raw = raw;
        return null;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        throw new UnsupportedOperationException();
    }

    private ByteArray buildCommonPart(int flags) {
        ByteArray ret = ByteArray.allocate(8);
        ret.int16(0, this.srcPort);
        ret.int16(2, this.dstPort);
        ret.int16(4, this.length);
        ret.int16(6, 0);
        ret = ret.concat(this.data.getRawPacket(flags));
        return ret;
    }

    public ByteArray buildIPv4UdpPacket(Ipv4Packet ipv4, int flags) {
        ByteArray common = this.buildCommonPart(flags);
        ByteArray pseudo = Utils.buildPseudoIPv4Header(ipv4, 17, common.length());
        ByteArray toCalculate = pseudo.concat(common);
        if ((flags & 1) == 0) {
            this.checksum = Utils.calculateChecksum(toCalculate, toCalculate.length());
            if (this.checksum == 0) {
                this.checksum = 65535;
            }
            common.int16(6, this.checksum);
            this.checksumCalculated();
        } else {
            this.checksumSkipped();
        }
        this.raw = new PacketDataBuffer(common);
        return common;
    }

    public ByteArray buildIPv6UdpPacket(Ipv6Packet ipv6, int flags) {
        ByteArray common = this.buildCommonPart(flags);
        ByteArray pseudo = Utils.buildPseudoIPv6Header(ipv6, 17, common.length());
        ByteArray toCalculate = pseudo.concat(common);
        if ((flags & 1) == 0) {
            this.checksum = Utils.calculateChecksum(toCalculate, toCalculate.length());
            if (this.checksum == 0) {
                this.checksum = 65535;
            }
            common.int16(6, this.checksum);
            this.checksumCalculated();
        } else {
            this.checksumSkipped();
        }
        this.raw = new PacketDataBuffer(common);
        return common;
    }

    @Override
    protected void __updateChecksum() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void __updateChildrenChecksum() {
    }

    protected void updateChecksumWithIPv4(Ipv4Packet ipv4) {
        this.raw.pktBuf.int16(6, 0);
        ByteArray pseudo = Utils.buildPseudoIPv4Header(ipv4, 17, this.raw.pktBuf.length());
        ByteArray toCalculate = pseudo.concat(this.raw.pktBuf);
        int cksum = Utils.calculateChecksum(toCalculate, toCalculate.length());
        if (cksum == 0) {
            cksum = 65535;
        }
        this.checksum = cksum;
        this.raw.pktBuf.int16(6, cksum);
        this.checksumCalculated();
    }

    protected void updateChecksumWithIPv6(Ipv6Packet ipv6) {
        this.raw.pktBuf.int16(6, 0);
        ByteArray pseudo = Utils.buildPseudoIPv6Header(ipv6, 17, this.raw.pktBuf.length());
        ByteArray toCalculate = pseudo.concat(this.raw.pktBuf);
        int cksum = Utils.calculateChecksum(toCalculate, toCalculate.length());
        if (cksum == 0) {
            cksum = 65535;
        }
        this.checksum = cksum;
        this.raw.pktBuf.int16(6, cksum);
        this.checksumCalculated();
    }

    @Override
    public UdpPacket copy() {
        UdpPacket ret = new UdpPacket();
        ret.srcPort = this.srcPort;
        ret.dstPort = this.dstPort;
        ret.length = this.length;
        ret.checksum = this.checksum;
        ret.data = this.data.copy();
        ret.data.recordParent(ret);
        return ret;
    }

    @Override
    public String description() {
        return "udp,tp_src=" + this.srcPort + ",tp_dst=" + this.dstPort + ",data=" + (this.data == null ? "" : this.data.description());
    }

    @Override
    public int getSrcPort() {
        return this.srcPort;
    }

    @Override
    public void setSrcPort(int srcPort) {
        if (this.raw != null) {
            this.raw.pktBuf.int16(0, srcPort);
            this.checksumSkipped();
        }
        this.srcPort = srcPort;
    }

    @Override
    public int getDstPort() {
        return this.dstPort;
    }

    @Override
    public void setDstPort(int dstPort) {
        if (this.raw != null) {
            this.raw.pktBuf.int16(2, dstPort);
            this.checksumSkipped();
        }
        this.dstPort = dstPort;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.clearRawPacket();
        this.length = length;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setChecksum(int checksum) {
        this.clearRawPacket();
        this.checksum = checksum;
    }

    public AbstractPacket getData() {
        return this.data;
    }

    public void setData(AbstractPacket data) {
        this.clearRawPacket();
        this.data = data;
    }

    public void setData(ByteArray data) {
        this.clearRawPacket();
        this.data = new PacketBytes(data);
        this.length = data.length() + 8;
    }

    @Override
    public void clearAllRawPackets() {
        this.clearRawPacket();
        this.data.clearAllRawPackets();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UdpPacket udpPacket = (UdpPacket)o;
        return this.srcPort == udpPacket.srcPort && this.dstPort == udpPacket.dstPort && this.length == udpPacket.length && this.checksum == udpPacket.checksum && Objects.equals(this.data, udpPacket.data);
    }

    public int hashCode() {
        return Objects.hash(this.srcPort, this.dstPort, this.length, this.checksum, this.data);
    }

    public String toString() {
        return "UdpPacket{srcPort=" + this.srcPort + ", dstPort=" + this.dstPort + ", length=" + this.length + ", checksum=" + this.checksum + ", data=" + this.data + "}";
    }
}

