/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Utils;
import io.vproxy.vpacket.AbstractPacket;
import io.vproxy.vpacket.EthernetPacket;
import io.vproxy.vpacket.PacketDataBuffer;
import java.util.Objects;

public class VXLanPacket
extends AbstractPacket {
    private int flags = 8;
    private int reserved1 = 0;
    private int vni;
    private int reserved2 = 0;
    private EthernetPacket packet;

    @Override
    public String from(PacketDataBuffer raw) {
        return this.from(raw, false);
    }

    public String from(PacketDataBuffer raw, boolean allowPartial) {
        ByteArray bytes = raw.pktBuf;
        if (bytes.length() < 8) {
            return "input packet length too short for a vxlan packet";
        }
        this.flags = bytes.uint8(0);
        this.reserved1 = bytes.uint24(1);
        this.vni = bytes.uint24(4);
        this.reserved2 = bytes.uint8(7);
        this.packet = new EthernetPacket();
        this.packet.recordParent(this);
        String err = this.packet.from(raw.sub(8), allowPartial);
        if (err != null) {
            return err;
        }
        this.raw = raw;
        return null;
    }

    @Override
    protected ByteArray buildPacket(int flags) {
        return ByteArray.allocate(8).set(0, (byte)this.flags).int24(1, this.reserved1).int24(4, this.vni).set(7, (byte)this.reserved2).concat(this.packet.getRawPacket(flags));
    }

    @Override
    protected void __updateChecksum() {
        this.__updateChildrenChecksum();
    }

    @Override
    protected void __updateChildrenChecksum() {
        this.packet.updateChecksum();
    }

    @Override
    public VXLanPacket copy() {
        VXLanPacket ret = new VXLanPacket();
        ret.flags = this.flags;
        ret.reserved1 = this.reserved1;
        ret.vni = this.vni;
        ret.reserved2 = this.reserved2;
        ret.packet = this.packet.copy();
        ret.packet.recordParent(ret);
        return ret;
    }

    @Override
    public void clearAllRawPackets() {
        this.clearRawPacket();
        this.packet.clearAllRawPackets();
    }

    @Override
    public String description() {
        return "vxlan,vni=" + this.vni + "," + this.packet.description();
    }

    public String toString() {
        return "VXLanPacket{flags=" + Utils.toBinaryString(this.flags) + ", reserved1=" + this.reserved1 + ", vni=" + Utils.runAvoidNull(() -> Integer.valueOf(this.vni), "null") + ", reserved2=" + this.reserved2 + ", packet=" + this.packet + "}";
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.clearRawPacket();
        this.flags = flags;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(int reserved1) {
        this.clearRawPacket();
        this.reserved1 = reserved1;
    }

    public int getVni() {
        return this.vni;
    }

    public void setVni(int vni) {
        this.clearRawPacket();
        this.vni = vni;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(int reserved2) {
        this.clearRawPacket();
        this.reserved2 = reserved2;
    }

    public EthernetPacket getPacket() {
        return this.packet;
    }

    public void setPacket(EthernetPacket packet) {
        this.clearRawPacket();
        this.packet = packet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VXLanPacket that = (VXLanPacket)o;
        return this.flags == that.flags && this.vni == that.vni && Objects.equals(this.packet, that.packet);
    }

    public int hashCode() {
        return Objects.hash(this.flags, this.vni, this.packet);
    }
}

