/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket.dhcp;

import io.vproxy.base.util.ByteArray;

public class DHCPOption {
    public byte type;
    public int len;
    protected ByteArray content;

    public ByteArray serialize() {
        if (this.content == null) {
            this.content = ByteArray.allocate(this.len);
        }
        return ByteArray.allocate(2).set(0, this.type).set(1, (byte)this.len).concat(this.content);
    }

    public int deserialize(ByteArray arr) throws Exception {
        if (arr.length() < 1) {
            throw new Exception("input too short for dhcp option: cannot read type");
        }
        this.type = arr.get(0);
        if (arr.length() < 2) {
            throw new Exception("input too short for dhcp option: cannot read len");
        }
        this.len = arr.uint8(1);
        if (arr.length() < 2 + this.len) {
            throw new Exception("input too short for dhcp option content: requiring" + this.len);
        }
        this.content = arr.sub(2, this.len);
        return 2 + this.len;
    }

    public String toString() {
        return "DHCPOption{type=" + this.type + ", len=" + this.len + ", content=" + (this.content == null ? "null" : this.content.toHexString()) + "}";
    }
}

