/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket.dhcp;

import io.vproxy.base.util.ByteArray;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.MacAddress;
import io.vproxy.vpacket.dhcp.DHCPOption;
import io.vproxy.vpacket.dhcp.options.DNSOption;
import io.vproxy.vpacket.dhcp.options.EndOption;
import io.vproxy.vpacket.dhcp.options.MessageTypeOption;
import io.vproxy.vpacket.dhcp.options.PadOption;
import io.vproxy.vpacket.dhcp.options.ParameterRequestListOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

public class DHCPPacket {
    private static final Map<Byte, Supplier<DHCPOption>> type2optionMap = new HashMap<Byte, Supplier<DHCPOption>>();
    public byte op;
    public byte htype = 1;
    public byte hlen = (byte)6;
    public byte hops = 0;
    public int xid = ThreadLocalRandom.current().nextInt();
    public int secs = 0;
    public int flags = 0;
    public IP ciaddr = IP.from("0.0.0.0");
    public IP yiaddr = IP.from("0.0.0.0");
    public IP siaddr = IP.from("0.0.0.0");
    public IP giaddr = IP.from("0.0.0.0");
    public MacAddress chaddr;
    public ByteArray sname = null;
    public ByteArray file = null;
    public int cookie = 1669485411;
    public LinkedList<DHCPOption> options = new LinkedList();

    public ByteArray serialize() {
        ByteArray pad;
        ByteArray ret = ByteArray.allocate(12).set(0, this.op).set(1, this.htype).set(2, this.hlen).set(3, this.hops).int32(4, this.xid).int16(8, this.secs).int16(10, this.flags).concat(ByteArray.from(this.ciaddr.getAddress())).concat(ByteArray.from(this.yiaddr.getAddress())).concat(ByteArray.from(this.siaddr.getAddress())).concat(ByteArray.from(this.giaddr.getAddress())).concat(this.chaddr.bytes).concat(ByteArray.allocate(10));
        if (this.sname == null) {
            ret = ret.concat(ByteArray.allocate(64));
        } else {
            ret = ret.concat(this.sname);
            if (this.sname.length() < 64) {
                pad = ByteArray.from(64 - this.sname.length());
                ret = ret.concat(pad);
            }
        }
        if (this.file == null) {
            ret = ret.concat(ByteArray.allocate(128));
        } else {
            ret = ret.concat(this.file);
            if (this.file.length() < 128) {
                pad = ByteArray.from(128 - this.file.length());
                ret = ret.concat(pad);
            }
        }
        ByteArray cookieArr = ByteArray.allocate(4);
        cookieArr.int32(0, this.cookie);
        ret = ret.concat(cookieArr);
        if (this.options.getLast().type != -1) {
            this.options.add(new EndOption());
        }
        for (DHCPOption opt : this.options) {
            ret = ret.concat(opt.serialize());
        }
        return ret;
    }

    public void deserialize(ByteArray arr) throws Exception {
        if (arr.length() < 240) {
            throw new Exception("failed parsing dhcp packet, too short, length: " + arr.length());
        }
        this.op = arr.get(0);
        this.htype = arr.get(1);
        if (this.htype != 1) {
            throw new Exception("unknown htype: not 1(ethernet): " + this.htype);
        }
        this.hlen = arr.get(2);
        if (this.hlen != 6) {
            throw new Exception("unexpected hlen: not 6: " + this.hlen);
        }
        this.hops = arr.get(3);
        this.xid = arr.int32(4);
        this.secs = arr.uint16(8);
        this.flags = arr.uint16(10);
        this.ciaddr = IP.from(arr.sub(12, 4).toJavaArray());
        this.yiaddr = IP.from(arr.sub(16, 4).toJavaArray());
        this.siaddr = IP.from(arr.sub(20, 4).toJavaArray());
        this.giaddr = IP.from(arr.sub(24, 4).toJavaArray());
        this.chaddr = new MacAddress(arr.sub(28, 6));
        this.sname = arr.sub(44, 64);
        this.file = arr.sub(108, 128);
        this.cookie = arr.int32(236);
        ByteArray optionsArr = arr.sub(240, arr.length() - 240);
        while (optionsArr.length() != 0) {
            byte type = optionsArr.get(0);
            Supplier<DHCPOption> supplier = type2optionMap.get(type);
            DHCPOption dhcpOption = supplier == null ? new DHCPOption() : supplier.get();
            int lenRead = dhcpOption.deserialize(optionsArr);
            optionsArr = optionsArr.sub(lenRead, optionsArr.length() - lenRead);
            this.options.add(dhcpOption);
            if (!(dhcpOption instanceof EndOption)) continue;
            break;
        }
    }

    public String toString() {
        return "DHCPPacket{op=" + this.op + ", htype=" + this.htype + ", hlen=" + this.hlen + ", hops=" + this.hops + ", xid=" + this.xid + ", secs=" + this.secs + ", flags=" + this.flags + ", ciaddr=" + this.ciaddr + ", yiaddr=" + this.yiaddr + ", siaddr=" + this.siaddr + ", giaddr=" + this.giaddr + ", chaddr=" + this.chaddr + ", sname='" + this.sname + "', file='" + this.file + "', options=" + this.options + "}";
    }

    static {
        type2optionMap.put((byte)-1, EndOption::new);
        type2optionMap.put((byte)0, PadOption::new);
        type2optionMap.put((byte)53, MessageTypeOption::new);
        type2optionMap.put((byte)55, ParameterRequestListOption::new);
        type2optionMap.put((byte)6, DNSOption::new);
    }
}

