/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket.dhcp.options;

import io.vproxy.base.util.ByteArray;
import io.vproxy.vpacket.dhcp.DHCPOption;

public class MessageTypeOption
extends DHCPOption {
    public byte msgType;

    public MessageTypeOption() {
        this(0);
    }

    public MessageTypeOption(int msgType) {
        this.msgType = (byte)msgType;
        this.type = (byte)53;
        this.len = 1;
    }

    @Override
    public ByteArray serialize() {
        this.content = ByteArray.from(this.msgType);
        return super.serialize();
    }

    @Override
    public int deserialize(ByteArray arr) throws Exception {
        int n = super.deserialize(arr);
        if (n != 3) {
            throw new Exception("dhcp option (message type) should have total length 3, but got " + n);
        }
        this.msgType = this.content.get(0);
        return n;
    }

    @Override
    public String toString() {
        return "MessageTypeOption{msgType=" + this.msgType + "}";
    }
}

