/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket.dhcp.options;

import io.vproxy.base.util.ByteArray;
import io.vproxy.vpacket.dhcp.DHCPOption;
import java.util.LinkedList;
import java.util.List;

public class ParameterRequestListOption
extends DHCPOption {
    public final List<Byte> params;

    public ParameterRequestListOption() {
        this(null);
    }

    public ParameterRequestListOption(List<Byte> params) {
        this.params = params == null ? new LinkedList<Byte>() : new LinkedList<Byte>(params);
        this.type = (byte)55;
    }

    public ParameterRequestListOption add(byte param) {
        this.params.add(param);
        return this;
    }

    @Override
    public ByteArray serialize() {
        this.len = this.params.size();
        this.content = ByteArray.allocate(this.len);
        int idx = 0;
        for (byte b : this.params) {
            this.content.set(idx, b);
            ++idx;
        }
        return super.serialize();
    }

    @Override
    public int deserialize(ByteArray arr) throws Exception {
        int n = super.deserialize(arr);
        for (int i = 0; i < this.content.length(); ++i) {
            this.params.add(this.content.get(i));
        }
        return n;
    }

    @Override
    public String toString() {
        return "ParameterRequestListOption{params=" + this.params + "}";
    }
}

