/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket.dns;

import io.vproxy.base.util.ByteArray;
import io.vproxy.vpacket.dns.DNSQuestion;
import io.vproxy.vpacket.dns.DNSResource;
import io.vproxy.vpacket.dns.Formatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DNSPacket {
    public int id;
    public boolean isResponse;
    public Opcode opcode;
    public boolean aa;
    public boolean tc;
    public boolean rd;
    public boolean ra;
    public RCode rcode;
    int qdcount;
    int ancount;
    int nscount;
    int arcount;
    public List<DNSQuestion> questions = new ArrayList<DNSQuestion>();
    public List<DNSResource> answers = new ArrayList<DNSResource>();
    public List<DNSResource> nameServers = new ArrayList<DNSResource>();
    public List<DNSResource> additionalResources = new ArrayList<DNSResource>();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSPacket packet = (DNSPacket)o;
        return this.id == packet.id && this.isResponse == packet.isResponse && this.aa == packet.aa && this.tc == packet.tc && this.rd == packet.rd && this.ra == packet.ra && this.opcode == packet.opcode && this.rcode == packet.rcode && Objects.equals(this.questions, packet.questions) && Objects.equals(this.answers, packet.answers) && Objects.equals(this.nameServers, packet.nameServers) && Objects.equals(this.additionalResources, packet.additionalResources);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.isResponse, this.opcode, this.aa, this.tc, this.rd, this.ra, this.rcode, this.questions, this.answers, this.nameServers, this.additionalResources});
    }

    public String toString() {
        return "DNSPacket{id=" + this.id + ", isResponse=" + this.isResponse + ", opcode=" + this.opcode + ", aa=" + this.aa + ", tc=" + this.tc + ", rd=" + this.rd + ", ra=" + this.ra + ", rcode=" + this.rcode + ", qdcount=" + this.qdcount + ", ancount=" + this.ancount + ", nscount=" + this.nscount + ", arcount=" + this.arcount + ", questions=" + this.questions + ", answers=" + this.answers + ", nameServers=" + this.nameServers + ", additionalResources=" + this.additionalResources + "}";
    }

    public ByteArray toByteArray() {
        return Formatter.format(this);
    }

    public static enum RCode {
        NoError(0),
        FormatError(1),
        ServerFailure(2),
        NameError(3),
        NotImplemented(4),
        Refused(5),
        YXDomain(6),
        YXRRSet(7),
        NXRRSet(8),
        NotAuth(9),
        NotZone(10),
        DSOTYPENI(11),
        BADVERS(16),
        BADKEY(17),
        BADTIME(18),
        BADMODE(19),
        BADNAME(20),
        BADALG(21),
        BADTRUNC(22),
        BADCOOKIE(23);

        public final int code;

        private RCode(int code) {
            this.code = code;
        }
    }

    public static enum Opcode {
        QUERY(0),
        IQUERY(1),
        STATUS(2),
        Notify(4),
        Update(5),
        DSO(6);

        public final int code;

        private Opcode(int code) {
            this.code = code;
        }
    }
}

