/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket.dns;

import io.vproxy.base.util.ByteArray;
import io.vproxy.base.util.Logger;
import io.vproxy.vpacket.dns.DNSClass;
import io.vproxy.vpacket.dns.DNSPacket;
import io.vproxy.vpacket.dns.DNSQuestion;
import io.vproxy.vpacket.dns.DNSResource;
import io.vproxy.vpacket.dns.DNSType;
import io.vproxy.vpacket.dns.InvalidDNSPacketException;
import io.vproxy.vpacket.dns.rdata.RData;
import java.util.LinkedList;
import java.util.List;

public class Formatter {
    private Formatter() {
    }

    public static ByteArray format(DNSPacket packet) {
        Formatter.fillPacket(packet);
        ByteArray ret = Formatter.formatHeader(packet);
        for (DNSQuestion q : packet.questions) {
            ret = ret.concat(Formatter.formatQuestion(q));
        }
        for (DNSResource r : packet.answers) {
            ret = ret.concat(Formatter.formatResource(r));
        }
        for (DNSResource r : packet.nameServers) {
            ret = ret.concat(Formatter.formatResource(r));
        }
        for (DNSResource r : packet.additionalResources) {
            ret = ret.concat(Formatter.formatResource(r));
        }
        return ret;
    }

    public static void fillPacket(DNSPacket packet) {
        packet.qdcount = packet.questions.size();
        packet.ancount = packet.answers.size();
        packet.nscount = packet.nameServers.size();
        packet.arcount = packet.additionalResources.size();
        for (DNSQuestion q : packet.questions) {
            Formatter.fillQuestion(q);
        }
        for (DNSResource r : packet.answers) {
            Formatter.fillResource(r);
        }
        for (DNSResource r : packet.nameServers) {
            Formatter.fillResource(r);
        }
        for (DNSResource r : packet.additionalResources) {
            Formatter.fillResource(r);
        }
    }

    public static void fillQuestion(DNSQuestion q) {
    }

    public static void fillResource(DNSResource r) {
        if (r.rdataBytes == null) {
            r.rdataBytes = r.rdata.toByteArray();
        }
        r.rdlen = r.rdataBytes.length();
    }

    public static ByteArray formatHeader(DNSPacket packet) {
        int len = 12;
        ByteArray header = ByteArray.allocate(len);
        byte qr_opcode_aa_tc_rd = 0;
        if (packet.isResponse) {
            qr_opcode_aa_tc_rd = (byte)(qr_opcode_aa_tc_rd | 0x80);
        }
        int opcode = packet.opcode.code;
        qr_opcode_aa_tc_rd = (byte)(qr_opcode_aa_tc_rd | (opcode <<= 3));
        if (packet.aa) {
            qr_opcode_aa_tc_rd = (byte)(qr_opcode_aa_tc_rd | 4);
        }
        if (packet.tc) {
            qr_opcode_aa_tc_rd = (byte)(qr_opcode_aa_tc_rd | 2);
        }
        if (packet.rd) {
            qr_opcode_aa_tc_rd = (byte)(qr_opcode_aa_tc_rd | 1);
        }
        byte ra_z_rcode = 0;
        if (packet.ra) {
            ra_z_rcode = (byte)(ra_z_rcode | 0x80);
        }
        ra_z_rcode = (byte)(ra_z_rcode | packet.rcode.code);
        header.int16(0, packet.id).set(2, qr_opcode_aa_tc_rd).set(3, ra_z_rcode).int16(4, packet.qdcount).int16(6, packet.ancount).int16(8, packet.nscount).int16(10, packet.arcount);
        return header;
    }

    public static ByteArray formatDomainName(String domain) {
        if (((String)domain).isEmpty()) {
            return ByteArray.from((byte)0);
        }
        if (!((String)domain).endsWith(".")) {
            domain = (String)domain + ".";
        }
        ByteArray ret = null;
        int start = 0;
        while (start < ((String)domain).length()) {
            int end = ((String)domain).indexOf(".", start + 1);
            assert (end != -1);
            String sub = ((String)domain).substring(start, end);
            start = end + 1;
            byte[] bytes = sub.getBytes();
            ByteArray arr = ByteArray.from((byte)bytes.length);
            if (bytes.length > 0) {
                arr = arr.concat(ByteArray.from(bytes));
            }
            if (ret == null) {
                ret = arr;
                continue;
            }
            ret = ret.concat(arr);
        }
        assert (ret != null);
        return ret.concat(ByteArray.from((byte)0));
    }

    public static ByteArray formatString(String s) {
        byte[] bytes = s.getBytes();
        ByteArray len = ByteArray.from((byte)bytes.length);
        if (bytes.length == 0) {
            return len;
        }
        return len.concat(ByteArray.from(bytes));
    }

    public static ByteArray formatQuestion(DNSQuestion q) {
        ByteArray qname = Formatter.formatDomainName(q.qname);
        ByteArray qtype_qclass = ByteArray.allocate(4);
        qtype_qclass.int16(0, q.qtype.code);
        qtype_qclass.int16(2, q.qclass.code);
        return qname.concat(qtype_qclass);
    }

    public static ByteArray formatResource(DNSResource r) {
        ByteArray ret;
        if (r.rawBytes != null) {
            return r.rawBytes;
        }
        ByteArray name = Formatter.formatDomainName(r.name);
        ByteArray type_class_ttl_rdlen = ByteArray.allocate(10);
        type_class_ttl_rdlen.int16(0, r.type.code);
        type_class_ttl_rdlen.int16(2, r.clazz.code);
        type_class_ttl_rdlen.int32(4, r.ttl);
        type_class_ttl_rdlen.int16(8, r.rdlen);
        r.rawBytes = ret = name.concat(type_class_ttl_rdlen).concat(r.rdataBytes);
        return ret;
    }

    public static List<DNSPacket> parsePackets(ByteArray input) throws InvalidDNSPacketException {
        int totalOffset;
        int offset;
        LinkedList<DNSPacket> packets = new LinkedList<DNSPacket>();
        for (totalOffset = 0; totalOffset < input.length(); totalOffset += offset) {
            ByteArray data = input.sub(totalOffset, input.length() - totalOffset);
            try {
                DNSResource r;
                ByteArray sub;
                int i;
                DNSPacket packet = new DNSPacket();
                offset = Formatter.parseHeader(packet, data);
                for (i = 0; i < packet.qdcount; ++i) {
                    DNSQuestion q = new DNSQuestion();
                    sub = data.sub(offset, data.length() - offset);
                    offset += Formatter.parseQuestion(q, sub, input);
                    packet.questions.add(q);
                }
                for (i = 0; i < packet.ancount; ++i) {
                    r = new DNSResource();
                    sub = data.sub(offset, data.length() - offset);
                    offset += Formatter.parseResource(r, sub, input);
                    packet.answers.add(r);
                }
                for (i = 0; i < packet.nscount; ++i) {
                    r = new DNSResource();
                    sub = data.sub(offset, data.length() - offset);
                    offset += Formatter.parseResource(r, sub, input);
                    packet.nameServers.add(r);
                }
                for (i = 0; i < packet.arcount; ++i) {
                    r = new DNSResource();
                    sub = data.sub(offset, data.length() - offset);
                    offset += Formatter.parseResource(r, sub, input);
                    packet.additionalResources.add(r);
                }
                packets.add(packet);
                assert (Logger.lowLevelDebug("parsed packet: " + packet));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw new InvalidDNSPacketException("not a complete packet", e);
            }
        }
        assert (totalOffset == input.length());
        return packets;
    }

    public static DNSPacket.Opcode parseOpcode(int opcode) throws InvalidDNSPacketException {
        DNSPacket.Opcode[] opcodeArr;
        for (DNSPacket.Opcode o : opcodeArr = DNSPacket.Opcode.values()) {
            if (o.code != opcode) continue;
            return o;
        }
        throw new InvalidDNSPacketException("unknown opcode: " + opcode);
    }

    public static DNSPacket.RCode parseRCode(int rcode) throws InvalidDNSPacketException {
        DNSPacket.RCode[] rCodeArr;
        for (DNSPacket.RCode r : rCodeArr = DNSPacket.RCode.values()) {
            if (r.code != rcode) continue;
            return r;
        }
        throw new InvalidDNSPacketException("unknown rcode: " + rcode);
    }

    public static String parseDomainName(ByteArray data, ByteArray rawPacket, int[] offsetHolder) {
        StringBuilder sb = new StringBuilder();
        int len = 0;
        int i = 0;
        while (true) {
            byte b = data.get(i);
            if (len == 0) {
                if (b == 0) break;
                if ((b & 0xC0) == 192) {
                    int offset = (b & 0x3F) << 8;
                    byte b2 = data.get(++i);
                    String name = Formatter.parseDomainName(rawPacket.sub(offset |= b2 & 0xFF, rawPacket.length() - offset), rawPacket, offsetHolder);
                    sb.append(name);
                    break;
                }
                len = b & 0xFF;
            } else {
                sb.append((char)b);
                if (--len == 0) {
                    sb.append(".");
                }
            }
            ++i;
        }
        String name = sb.toString();
        offsetHolder[0] = i + 1;
        return name;
    }

    public static DNSType parseType(int type, boolean question) throws InvalidDNSPacketException {
        DNSType[] typeArr;
        for (DNSType t : typeArr = DNSType.values()) {
            if (t.code != type) continue;
            if (!question && t.question) {
                throw new InvalidDNSPacketException("the type " + t + " is only allowed for questions");
            }
            return t;
        }
        return DNSType.OTHER;
    }

    public static int parseHeader(DNSPacket packet, ByteArray data) throws InvalidDNSPacketException {
        byte ra_z_rcode;
        packet.id = data.uint16(0);
        byte qr_opcode_aa_tc_rd = data.get(2);
        if ((qr_opcode_aa_tc_rd & 0x80) == 128) {
            packet.isResponse = true;
        }
        int _i = qr_opcode_aa_tc_rd & 0xFF;
        _i >>= 3;
        packet.opcode = Formatter.parseOpcode(_i &= 0xF);
        if ((qr_opcode_aa_tc_rd & 4) == 4) {
            packet.aa = true;
        }
        if ((qr_opcode_aa_tc_rd & 2) == 2) {
            packet.tc = true;
        }
        if ((qr_opcode_aa_tc_rd & 1) == 1) {
            packet.rd = true;
        }
        if (((ra_z_rcode = data.get(3)) & 0x80) == 128) {
            packet.ra = true;
        }
        _i = ra_z_rcode & 0xF;
        packet.rcode = Formatter.parseRCode(_i);
        packet.qdcount = data.uint16(4);
        packet.ancount = data.uint16(6);
        packet.nscount = data.uint16(8);
        packet.arcount = data.uint16(10);
        return 12;
    }

    private static DNSClass parseClass(int clazz, boolean question) throws InvalidDNSPacketException {
        DNSClass[] classArr;
        for (DNSClass c : classArr = DNSClass.values()) {
            if (c.code != clazz) continue;
            if (!question && c.question) {
                throw new InvalidDNSPacketException("the class " + c + " is only allowed for questions");
            }
            return c;
        }
        throw new InvalidDNSPacketException("unknown class: " + clazz);
    }

    public static int parseQuestion(DNSQuestion q, ByteArray data, ByteArray rawPacket) throws InvalidDNSPacketException {
        int[] offsetHolder = new int[]{0};
        q.qname = Formatter.parseDomainName(data, rawPacket, offsetHolder);
        int offset = offsetHolder[0];
        int qtype = data.uint16(offset);
        int qclass = data.uint16(offset + 2);
        q.qtype = Formatter.parseType(qtype, true);
        q.qclass = Formatter.parseClass(qclass, true);
        return offset + 4;
    }

    public static int parseResource(DNSResource r, ByteArray data, ByteArray rawPacket) throws InvalidDNSPacketException {
        ByteArray rdataBytes;
        int[] offsetHolder = new int[]{0};
        r.name = Formatter.parseDomainName(data, rawPacket, offsetHolder);
        int offset = offsetHolder[0];
        int type = data.uint16(offset);
        int clazz = data.uint16(offset + 2);
        int ttl = data.int32(offset + 4);
        int rdlen = data.uint16(offset + 8);
        r.type = Formatter.parseType(type, false);
        r.clazz = r.type == DNSType.OPT ? DNSClass.NOT_CLASS : Formatter.parseClass(clazz, false);
        r.ttl = ttl;
        r.rdlen = rdlen;
        if (r.rdlen < 0) {
            throw new InvalidDNSPacketException("invalid rdlen: " + r.rdlen);
        }
        r.rdataBytes = rdataBytes = data.sub(offset += 10, r.rdlen);
        RData rData = RData.newRData(r.type);
        if (rData != null) {
            rData.fromByteArray(rdataBytes, rawPacket);
            r.rdata = rData;
        }
        int len = offset + r.rdlen;
        r.rawBytes = data.sub(0, len);
        return len;
    }
}

