/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket.dns.rdata;

import io.vproxy.base.util.ByteArray;
import io.vproxy.vfd.IP;
import io.vproxy.vfd.IPv4;
import io.vproxy.vpacket.dns.DNSType;
import io.vproxy.vpacket.dns.InvalidDNSPacketException;
import io.vproxy.vpacket.dns.rdata.RData;
import java.util.Objects;

public class A
implements RData {
    public IPv4 address;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        A a = (A)o;
        return Objects.equals(this.address, a.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        return "A{address=" + this.address + "}";
    }

    @Override
    public ByteArray toByteArray() {
        return ByteArray.from(this.address.getAddress());
    }

    @Override
    public DNSType type() {
        return DNSType.A;
    }

    @Override
    public void fromByteArray(ByteArray data, ByteArray rawPacket) throws InvalidDNSPacketException {
        if (data.length() != 4) {
            throw new InvalidDNSPacketException("A record rdata length is not wrong: " + data.length());
        }
        byte[] arr = data.toJavaArray();
        this.address = IP.fromIPv4(arr);
    }
}

