/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket.dns.rdata;

import io.vproxy.base.util.ByteArray;
import io.vproxy.vpacket.dns.DNSType;
import io.vproxy.vpacket.dns.Formatter;
import io.vproxy.vpacket.dns.InvalidDNSPacketException;
import io.vproxy.vpacket.dns.rdata.RData;
import java.util.Objects;

public class CNAME
implements RData {
    public String cname;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CNAME cname1 = (CNAME)o;
        return Objects.equals(this.cname, cname1.cname);
    }

    public int hashCode() {
        return Objects.hash(this.cname);
    }

    public String toString() {
        return "CNAME{cname='" + this.cname + "'}";
    }

    @Override
    public ByteArray toByteArray() {
        return Formatter.formatDomainName(this.cname);
    }

    @Override
    public DNSType type() {
        return DNSType.CNAME;
    }

    @Override
    public void fromByteArray(ByteArray data, ByteArray rawPacket) throws InvalidDNSPacketException {
        int[] offsetHolder = new int[]{0};
        String cname = Formatter.parseDomainName(data, rawPacket, offsetHolder);
        if (offsetHolder[0] != data.length()) {
            throw new InvalidDNSPacketException("more bytes readable in the cname rdata field: cname=" + cname + ", data.len=" + data.length());
        }
        this.cname = cname;
    }
}

