/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vpacket.dns.rdata;

import io.vproxy.base.util.ByteArray;
import io.vproxy.vpacket.dns.DNSType;
import io.vproxy.vpacket.dns.Formatter;
import io.vproxy.vpacket.dns.InvalidDNSPacketException;
import io.vproxy.vpacket.dns.rdata.RData;

public class SRV
implements RData {
    public int priority;
    public int weight;
    public int port;
    public String target;

    @Override
    public ByteArray toByteArray() {
        ByteArray priority_weight_port = ByteArray.allocate(6);
        priority_weight_port.int16(0, this.priority).int16(2, this.weight).int16(4, this.port);
        return priority_weight_port.concat(Formatter.formatDomainName(this.target));
    }

    @Override
    public DNSType type() {
        return DNSType.SRV;
    }

    @Override
    public void fromByteArray(ByteArray data, ByteArray rawPacket) throws InvalidDNSPacketException {
        this.priority = rawPacket.uint16(0);
        this.weight = rawPacket.uint16(2);
        this.port = rawPacket.uint16(4);
        int[] offsetHolder = new int[]{0};
        this.target = Formatter.parseDomainName(data.sub(6, data.length() - 6), rawPacket, offsetHolder);
        if (offsetHolder[0] != data.length()) {
            throw new InvalidDNSPacketException("more bytes readable in the srv rdata field: " + this + ", data.len=" + data.length());
        }
    }

    public String toString() {
        return "SRV{priority=" + this.priority + ", weight=" + this.weight + ", port=" + this.port + ", target='" + this.target + "'}";
    }
}

