/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

public class StringsKt {
    private StringsKt() {
    }

    public static StringBuilder clear(StringBuilder self) {
        return self.delete(0, self.length());
    }

    public static String concatToString(char[] self, int startIndex, int endIndex) {
        return new String(self, startIndex, endIndex - startIndex);
    }

    public static boolean isBlank(CharSequence self) {
        if (self.length() == 0) {
            return true;
        }
        int l = self.length();
        for (int i = 0; i < l; ++i) {
            char c = self.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static char last(CharSequence self) {
        if (self.length() == 0) {
            throw new IndexOutOfBoundsException();
        }
        return self.charAt(self.length() - 1);
    }

    public static String repeat(CharSequence self, int times) {
        StringBuilder sb = new StringBuilder(self.length() * times);
        for (int i = 0; i < times; ++i) {
            sb.append(self);
        }
        return sb.toString();
    }

    public static CharSequence trim(CharSequence self) {
        return self.toString().trim();
    }

    private static int indexOf(CharSequence self, CharSequence matcher, int startIndex, boolean ignoreCase, boolean backToFront, boolean matchOnlyOnce) {
        int i;
        if (self.length() < matcher.length()) {
            return -1;
        }
        if (self.length() == 0) {
            return 0;
        }
        if (matcher.length() == 0) {
            if (startIndex < 0) {
                return 0;
            }
            if (startIndex >= self.length()) {
                return self.length();
            }
            return startIndex;
        }
        if (startIndex < 0) {
            startIndex = 0;
        } else if (startIndex >= self.length()) {
            startIndex = self.length() - 1;
        }
        if (backToFront) {
            int possibleIndex = self.length() - matcher.length();
            if (startIndex > possibleIndex) {
                startIndex = possibleIndex;
            }
        } else if (self.length() - startIndex < matcher.length()) {
            return -1;
        }
        if (backToFront) {
            for (i = startIndex; i >= 0; --i) {
                if (StringsKt.match(self, matcher, i, ignoreCase)) {
                    return i;
                }
                if (!matchOnlyOnce) continue;
                return -1;
            }
        } else {
            for (i = startIndex; i < self.length(); ++i) {
                if (StringsKt.match(self, matcher, i, ignoreCase)) {
                    return i;
                }
                if (!matchOnlyOnce) continue;
                return -1;
            }
        }
        return -1;
    }

    private static boolean match(CharSequence self, CharSequence matcher, int index, boolean ignoreCase) {
        int l = matcher.length();
        for (int i = 0; i < l; ++i) {
            boolean same;
            char a = self.charAt(index + i);
            char b = matcher.charAt(i);
            if (ignoreCase) {
                same = Character.toLowerCase(a) == Character.toLowerCase(b);
            } else {
                boolean bl = same = a == b;
            }
            if (same) continue;
            return false;
        }
        return true;
    }

    public static boolean contains$default(CharSequence self, CharSequence other, boolean ignoreCase, int mask, Object handler) {
        if ((mask & 2) == 2) {
            ignoreCase = false;
        }
        return StringsKt.indexOf(self, other, 0, ignoreCase, false, false) >= 0;
    }

    public static boolean startsWith$default(String self, String other, boolean ignoreCase, int mask, Object handler) {
        return StringsKt.startsWith$default((CharSequence)self, (CharSequence)other, ignoreCase, mask, handler);
    }

    public static boolean startsWith$default(CharSequence self, CharSequence other, boolean ignoreCase, int mask, Object handler) {
        if ((mask & 2) == 2) {
            ignoreCase = false;
        }
        return StringsKt.indexOf(self, other, 0, ignoreCase, false, true) >= 0;
    }

    public static boolean endsWith$default(String self, String other, boolean ignoreCase, int mask, Object handler) {
        return StringsKt.endsWith$default((CharSequence)self, (CharSequence)other, ignoreCase, mask, handler);
    }

    public static boolean endsWith$default(CharSequence self, CharSequence other, boolean ignoreCase, int mask, Object handler) {
        if ((mask & 2) == 2) {
            ignoreCase = false;
        }
        return StringsKt.indexOf(self, other, self.length() - other.length(), ignoreCase, true, true) >= 0;
    }

    public static int indexOf$default(CharSequence self, String other, int startIndex, boolean ignoreCase, int mask, Object handler) {
        return StringsKt.indexOf$default(self, (CharSequence)other, startIndex, ignoreCase, mask, handler);
    }

    public static int indexOf$default(CharSequence self, CharSequence other, int startIndex, boolean ignoreCase, int mask, Object handler) {
        if ((mask & 2) == 2) {
            startIndex = 0;
        }
        if ((mask & 4) == 4) {
            ignoreCase = false;
        }
        return StringsKt.indexOf(self, other, startIndex, ignoreCase, false, false);
    }

    public static int lastIndexOf$default(CharSequence self, String other, int startIndex, boolean ignoreCase, int mask, Object handler) {
        return StringsKt.lastIndexOf$default(self, (CharSequence)other, startIndex, ignoreCase, mask, handler);
    }

    public static int lastIndexOf$default(CharSequence self, CharSequence other, int startIndex, boolean ignoreCase, int mask, Object handler) {
        if ((mask & 2) == 2) {
            startIndex = self.length();
        }
        if ((mask & 4) == 4) {
            ignoreCase = false;
        }
        return StringsKt.indexOf(self, other, startIndex, ignoreCase, true, false);
    }
}

