/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect;

import kotlin.reflect.KClass;

public class KClassImpl
implements KClass {
    private final Class<?> javaClass;

    public KClassImpl(Class<?> javaClass) {
        this.javaClass = javaClass;
    }

    @Override
    public String getQualifiedName() {
        return KClassImpl.formatQualifiedName(this.javaClass);
    }

    private static String formatQualifiedName(Class<?> javaClass) {
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return "kotlin.Int";
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return "kotlin.Long";
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return "kotlin.Float";
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return "kotlin.Double";
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return "kotlin.Boolean";
        }
        if (javaClass == Character.class || javaClass == Character.TYPE) {
            return "kotlin.Char";
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return "kotlin.Short";
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return "kotlin.Byte";
        }
        if (javaClass == String.class) {
            return "kotlin.String";
        }
        if (javaClass.isArray()) {
            Class<?> comp = javaClass.getComponentType();
            if (comp == Integer.TYPE) {
                return "kotlin.IntArray";
            }
            if (comp == Long.TYPE) {
                return "kotlin.LongArray";
            }
            if (comp == Float.TYPE) {
                return "kotlin.FloatArray";
            }
            if (comp == Double.TYPE) {
                return "kotlin.DoubleArray";
            }
            if (comp == Boolean.TYPE) {
                return "kotlin.BooleanArray";
            }
            if (comp == Character.TYPE) {
                return "kotlin.CharArray";
            }
            if (comp == Short.TYPE) {
                return "kotlin.ShortArray";
            }
            if (comp == Byte.TYPE) {
                return "kotlin.ByteArray";
            }
            return "kotlin.Array";
        }
        return javaClass.getName();
    }

    @Override
    public boolean isInstance(Object obj) {
        if ((this.javaClass == Integer.class || this.javaClass == Integer.TYPE) && obj != null) {
            return obj instanceof Integer;
        }
        if ((this.javaClass == Long.class || this.javaClass == Long.TYPE) && obj != null) {
            return obj instanceof Long;
        }
        if ((this.javaClass == Float.class || this.javaClass == Float.TYPE) && obj != null) {
            return obj instanceof Float;
        }
        if ((this.javaClass == Double.class || this.javaClass == Double.TYPE) && obj != null) {
            return obj instanceof Double;
        }
        if ((this.javaClass == Boolean.class || this.javaClass == Boolean.TYPE) && obj != null) {
            return obj instanceof Boolean;
        }
        if ((this.javaClass == Character.class || this.javaClass == Character.TYPE) && obj != null) {
            return obj instanceof Character;
        }
        if ((this.javaClass == Short.class || this.javaClass == Short.TYPE) && obj != null) {
            return obj instanceof Short;
        }
        if ((this.javaClass == Byte.class || this.javaClass == Byte.TYPE) && obj != null) {
            return obj instanceof Byte;
        }
        return this.javaClass.isInstance(obj);
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KClass kClass = (KClass)o;
        return this.getQualifiedName().equals(kClass.getQualifiedName());
    }
}

