/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.animation;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.callback.Callback;
import io.vproxy.commons.graph.Graph;
import io.vproxy.commons.graph.GraphEdge;
import io.vproxy.commons.graph.GraphPath;
import io.vproxy.vfx.animation.AnimationApplyFunction;
import io.vproxy.vfx.animation.AnimationEdge;
import io.vproxy.vfx.animation.AnimationInterrupted;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.animation.AnimationStateTransferBeginCallback;
import io.vproxy.vfx.util.algebradata.AlgebraData;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.animation.AnimationTimer;

public class AnimationGraph<T extends AlgebraData<T>> {
    private final Graph<AnimationNode<T>> graph;
    private final AnimationApplyFunction<T> apply;
    private final AnimationStateTransferBeginCallback<T> stateTransferBeginCallback;
    private AnimationNode<T> currentNode;
    private AnimationEdge<T> currentEdge = null;
    private Iterator<AnimationEdge<T>> iterator = null;
    private Animation timer = null;

    AnimationGraph(Graph<AnimationNode<T>> graph, AnimationApplyFunction<T> apply, AnimationStateTransferBeginCallback<T> stateTransferBeginCallback, AnimationNode<T> initialNode) {
        this.graph = graph;
        this.apply = apply;
        this.stateTransferBeginCallback = stateTransferBeginCallback;
        if (!graph.containsNode(initialNode)) {
            throw new IllegalArgumentException("`initialNode` is not contained in `nodes`");
        }
        this.currentNode = initialNode;
        this.apply(null, initialNode);
    }

    public boolean isPlaying() {
        return this.timer != null;
    }

    public boolean isReverting() {
        Animation timer = this.timer;
        if (timer != null) {
            return timer.isReverting;
        }
        return false;
    }

    public void stopAndSetNode(AnimationNode<T> node) {
        if (!this.graph.containsNode(node)) {
            throw new IllegalArgumentException();
        }
        this.currentNode = node;
        this.currentEdge = null;
        this.iterator = null;
        Animation timer = this.timer;
        this.timer = null;
        if (timer != null) {
            timer.stop();
        }
        this.apply(null, this.currentNode);
    }

    private void revertToLastNode(Callback<Void, Exception> cb) {
        Animation timer = this.timer;
        if (timer == null) {
            cb.succeeded();
            return;
        }
        timer.revertCurrentAnimation(cb);
    }

    public AnimationNode<T> getCurrentNode() {
        return this.currentNode;
    }

    public AnimationNode<T> getNextNode() {
        if (this.currentEdge == null) {
            return null;
        }
        return this.currentEdge.to;
    }

    private void apply(AnimationNode<T> from, AnimationNode<T> to, T data) {
        this.apply.apply(from, to, data);
    }

    private void apply(AnimationNode<T> from, AnimationNode<T> to) {
        this.apply.apply(from, to, to.value);
        to.stateTransferFinish.animationStateTransferFinish(from, to);
    }

    public void play(AnimationNode<T> key) {
        this.play(key, (Callback<Void, Exception>)Callback.ofIgnoreExceptionFunction(v -> {}));
    }

    public void play(AnimationNode<T> key, Callback<Void, Exception> cb) {
        this.play(List.of(key), cb);
    }

    /*
     * WARNING - void declaration
     */
    public void play(List<AnimationNode<T>> keys, Callback<Void, Exception> cb) {
        void var4_6;
        if (keys.isEmpty()) {
            cb.succeeded();
            return;
        }
        if (this.isPlaying()) {
            this.cancelAndPlay(keys, cb);
            return;
        }
        if (((Object)keys.get(0)).equals(this.currentNode)) {
            LinkedList<AnimationNode<T>> linked = new LinkedList<AnimationNode<T>>(keys);
            keys = linked;
            while (!linked.isEmpty() && ((Object)linked.peekFirst()).equals(this.currentNode)) {
                linked.remove(this.currentNode);
            }
        }
        if (keys.isEmpty()) {
            cb.succeeded();
            return;
        }
        if (new HashSet<AnimationNode<T>>(keys).size() != keys.size()) {
            throw new IllegalArgumentException("duplicated nodes in " + keys);
        }
        for (AnimationNode animationNode : keys) {
            if (!((Object)((Object)animationNode)).equals(this.currentNode)) continue;
            throw new IllegalArgumentException("node in " + keys + " conflict with current node: " + this.currentNode);
        }
        AnimationNode lastNode = this.currentNode;
        Object var4_5 = null;
        for (AnimationNode<T> key : keys) {
            GraphPath<AnimationNode<T>> newPath;
            try {
                newPath = this.prepareForPlaying(lastNode, key, (GraphPath<AnimationNode<T>>)var4_6, keys);
            }
            catch (Exception e) {
                Logger.warn((LogType)LogType.ALERT, (String)("unable to find path for playing animation " + keys + ": from " + lastNode + " to " + key));
                cb.failed((Throwable)e);
                return;
            }
            lastNode = (AnimationNode)newPath.to;
            if (var4_6 == null) {
                GraphPath<AnimationNode<T>> graphPath = newPath;
                continue;
            }
            GraphPath graphPath = var4_6.concat(newPath);
        }
        assert (var4_6 != null);
        this.iterator = var4_6.path.iterator();
        this.timer = new Animation(cb);
        this.timer.start();
    }

    private void cancelAndPlay(List<AnimationNode<T>> keys, Callback<Void, Exception> cb) {
        GraphPath nextNodePath;
        GraphPath<AnimationNode<T>> currentNodePath;
        if (this.currentEdge == null) {
            this.stopAndSetNode(this.currentNode);
            this.play(keys, cb);
            return;
        }
        AnimationNode<T> currentNode = this.currentNode;
        AnimationNode<T> firstNode = keys.get(0);
        if (currentNode == firstNode) {
            this.playAfterRevert(currentNode, keys, cb);
            return;
        }
        AnimationNode nextNode = this.currentEdge.to;
        if (nextNode == firstNode) {
            this.playAtNext(nextNode, keys, cb);
            return;
        }
        try {
            currentNodePath = this.findShortestPaths(currentNode, firstNode, Collections.emptySet());
        }
        catch (Exception e) {
            Logger.warn((LogType)LogType.ALERT, (String)("unable to find path for playing animation from " + currentNode + " to " + firstNode));
            cb.failed((Throwable)e);
            return;
        }
        try {
            nextNodePath = this.findShortestPaths(nextNode, firstNode, Collections.emptySet());
        }
        catch (Exception e) {
            Logger.warn((LogType)LogType.ALERT, (String)("unable to find path for playing animation from " + nextNode + " to " + firstNode));
            cb.failed((Throwable)e);
            return;
        }
        if (currentNodePath.length > nextNodePath.length) {
            this.playAtNext(nextNode, keys, cb);
        } else {
            this.playAfterRevert(currentNode, keys, cb);
        }
    }

    private void playAtNext(final AnimationNode<T> n, final List<AnimationNode<T>> keys, final Callback<Void, Exception> cb) {
        if (this.isReverting()) {
            this.timer.cancelRevertAndStopAtNext(cb);
            return;
        }
        this.timer.stopAtNext(new Callback<Void, Exception>(){

            protected void onSucceeded(Void value) {
                AnimationGraph.this.stopAndSetNode(n);
                AnimationGraph.this.play(keys, (Callback<Void, Exception>)cb);
            }

            protected void onFailed(Exception e) {
                cb.failed((Throwable)e);
            }
        });
    }

    private void playAfterRevert(final AnimationNode<T> n, final List<AnimationNode<T>> keys, final Callback<Void, Exception> cb) {
        if (this.isReverting()) {
            this.timer.setCB(cb);
            return;
        }
        this.revertToLastNode(new Callback<Void, Exception>(){

            protected void onSucceeded(Void value) {
                AnimationGraph.this.stopAndSetNode(n);
                AnimationGraph.this.play(keys, (Callback<Void, Exception>)cb);
            }

            protected void onFailed(Exception e) {
                cb.failed((Throwable)e);
            }
        });
    }

    private GraphPath<AnimationNode<T>> findShortestPaths(AnimationNode<T> from, AnimationNode<T> to, Set<AnimationNode<T>> skip) {
        Map paths = this.graph.shortestPaths(from, skip);
        GraphPath ls = (GraphPath)paths.get(to);
        if (ls == null) {
            throw new IllegalArgumentException("cannot find path from " + from + " to " + to + ", skip=" + skip);
        }
        return ls;
    }

    private GraphPath<AnimationNode<T>> prepareForPlaying(AnimationNode<T> from, AnimationNode<T> to, GraphPath<AnimationNode<T>> path, List<AnimationNode<T>> keys) {
        HashSet<AnimationNode<T>> skip = new HashSet<AnimationNode<T>>();
        if (path != null) {
            for (GraphEdge e : path.path) {
                skip.add((AnimationNode)e.from);
                skip.add((AnimationNode)e.to);
            }
        }
        skip.addAll(keys);
        skip.remove(from);
        skip.remove(to);
        return this.findShortestPaths(from, to, skip);
    }

    private class Animation
    extends AnimationTimer {
        long beginTs = 0L;
        long lastOverflow = 0L;
        Callback<Void, Exception> cb;
        private boolean isReverting = false;
        private boolean terminateAtNext = false;
        private long revertBeginTime = 0L;

        private Animation(Callback<Void, Exception> cb) {
            this.cb = cb;
        }

        public void handle(long now) {
            Object data;
            if (this.beginTs == 0L) {
                this.beginTs = now;
                return;
            }
            if (this.isReverting && this.revertBeginTime == 0L) {
                this.revertBeginTime = now;
                return;
            }
            if (AnimationGraph.this.currentEdge == null) {
                if (this.checkEnd()) {
                    return;
                }
                AnimationGraph.this.currentEdge = AnimationGraph.this.iterator.next();
                AnimationGraph.this.stateTransferBeginCallback.animationStateTransferBegin(AnimationGraph.this.currentEdge.from, AnimationGraph.this.currentEdge.to);
                this.beginTs = now - this.lastOverflow;
            }
            AnimationEdge currentEdge0 = AnimationGraph.this.currentEdge;
            if (!this.isReverting) {
                long delta = (now - this.beginTs) / 1000000L;
                if (delta >= AnimationGraph.this.currentEdge.durationMillis) {
                    data = AnimationGraph.this.currentEdge.to.value;
                    this.lastOverflow = delta - AnimationGraph.this.currentEdge.durationMillis;
                    AnimationGraph.this.currentNode = AnimationGraph.this.currentEdge.to;
                    AnimationGraph.this.currentEdge = null;
                    AnimationGraph.this.currentNode.stateTransferFinish.animationStateTransferFinish(currentEdge0.from, currentEdge0.to);
                    this.checkEnd();
                } else {
                    double p = (double)delta / (double)AnimationGraph.this.currentEdge.durationMillis;
                    data = AnimationGraph.this.currentEdge.from.value.plus(AnimationGraph.this.currentEdge.to.value.minus(AnimationGraph.this.currentEdge.from.value).multiply(p));
                }
            } else {
                long delta = (now - this.revertBeginTime) / 1000000L;
                long elapsed = (this.revertBeginTime - this.beginTs) / 1000000L;
                if (delta >= elapsed) {
                    data = AnimationGraph.this.currentEdge.from.value;
                    AnimationGraph.this.currentNode = AnimationGraph.this.currentEdge.from;
                    AnimationGraph.this.currentEdge = null;
                    AnimationGraph.this.currentNode.stateTransferFinish.animationStateTransferFinish(currentEdge0.to, currentEdge0.from);
                    this.checkEnd();
                } else {
                    double p = (double)(elapsed - delta) / (double)AnimationGraph.this.currentEdge.durationMillis;
                    data = AnimationGraph.this.currentEdge.from.value.plus(AnimationGraph.this.currentEdge.to.value.minus(AnimationGraph.this.currentEdge.from.value).multiply(p));
                }
            }
            AnimationGraph.this.apply(currentEdge0.from, currentEdge0.to, data);
        }

        private boolean checkEnd() {
            if (this.terminateAtNext || !AnimationGraph.this.iterator.hasNext()) {
                AnimationGraph.this.currentEdge = null;
                AnimationGraph.this.iterator = null;
                AnimationGraph.this.timer = null;
                this.stop();
                this.cb.succeeded();
                return true;
            }
            return false;
        }

        public void revertCurrentAnimation(Callback<Void, Exception> cb) {
            this.isReverting = true;
            this.terminateAtNext = true;
            AnimationGraph.this.currentNode.stateTransferFinish.animationStateTransferFinish(AnimationGraph.this.currentEdge.to, AnimationGraph.this.currentEdge.from);
            this.setCB(cb);
        }

        public void stopAtNext(Callback<Void, Exception> cb) {
            this.terminateAtNext = true;
            this.setCB(cb);
        }

        public void setCB(Callback<Void, Exception> cb) {
            this.cb.failed((Throwable)new AnimationInterrupted());
            this.cb = cb;
        }

        public void cancelRevertAndStopAtNext(Callback<Void, Exception> cb) {
            this.isReverting = false;
            this.terminateAtNext = true;
            AnimationEdge currentEdge = AnimationGraph.this.currentEdge;
            AnimationGraph.this.stateTransferBeginCallback.animationStateTransferBegin(currentEdge.from, currentEdge.to);
            this.setCB(cb);
        }
    }
}

