/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.animation;

import io.vproxy.commons.graph.GraphBuilder;
import io.vproxy.vfx.animation.AnimationApplyFunction;
import io.vproxy.vfx.animation.AnimationEdge;
import io.vproxy.vfx.animation.AnimationGraph;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.animation.AnimationStateTransferBeginCallback;
import io.vproxy.vfx.util.algebradata.AlgebraData;
import io.vproxy.vfx.util.algebradata.DoubleDoubleFunction;

public class AnimationGraphBuilder<T extends AlgebraData<T>> {
    private final GraphBuilder<AnimationNode<T>> builder = new GraphBuilder();
    private AnimationStateTransferBeginCallback<T> stateTransferBeginCallback = null;
    private AnimationApplyFunction<T> apply;

    public static <T extends AlgebraData<T>> AnimationGraphBuilder<T> simpleTwoNodeGraph(AnimationNode<T> a, AnimationNode<T> b, long millis) {
        return new AnimationGraphBuilder<T>().addNode(a).addNode(b).addTwoWayEdge(a, b, millis);
    }

    public AnimationGraphBuilder<T> addNode(AnimationNode<T> n) {
        this.builder.addNode(n);
        return this;
    }

    public AnimationGraphBuilder<T> addEdge(AnimationNode<T> from, AnimationNode<T> to, long durationMillis) {
        return this.addEdge(from, to, durationMillis, t -> t);
    }

    public AnimationGraphBuilder<T> addEdge(AnimationNode<T> from, AnimationNode<T> to, long durationMillis, DoubleDoubleFunction function) {
        if (durationMillis < 0L) {
            throw new IllegalArgumentException("`durationMillis` < 0");
        }
        this.builder.addEdge(new AnimationEdge<T>(from, to, durationMillis, function));
        return this;
    }

    public AnimationGraphBuilder<T> addTwoWayEdge(AnimationNode<T> from, AnimationNode<T> to, long durationMillis) {
        return this.addTwoWayEdge(from, to, durationMillis, t -> t);
    }

    public AnimationGraphBuilder<T> addTwoWayEdge(AnimationNode<T> from, AnimationNode<T> to, long durationMillis, DoubleDoubleFunction function) {
        if (durationMillis < 0L) {
            throw new IllegalArgumentException("`durationMillis` < 0");
        }
        this.builder.addEdge(new AnimationEdge<T>(from, to, durationMillis, function));
        this.builder.addEdge(new AnimationEdge<T>(to, from, durationMillis, function));
        return this;
    }

    public AnimationGraphBuilder<T> setApply(AnimationApplyFunction<T> apply) {
        this.apply = apply;
        return this;
    }

    public AnimationGraphBuilder<T> setStateTransferBeginCallback(AnimationStateTransferBeginCallback<T> stateTransferBeginCallback) {
        this.stateTransferBeginCallback = stateTransferBeginCallback;
        return this;
    }

    public AnimationGraph<T> build(AnimationNode<T> initialNode) {
        if (this.apply == null) {
            throw new IllegalArgumentException("`apply` not set");
        }
        AnimationStateTransferBeginCallback<T> beginCB = this.stateTransferBeginCallback;
        if (beginCB == null) {
            beginCB = (from, to) -> {};
        }
        this.apply.apply(null, initialNode, initialNode.value);
        return new AnimationGraph<T>(this.builder.build(), this.apply, beginCB, initialNode);
    }
}

