/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.component.keychooser;

import com.github.kwhat.jnativehook.GlobalScreen;
import com.github.kwhat.jnativehook.keyboard.NativeKeyEvent;
import com.github.kwhat.jnativehook.keyboard.NativeKeyListener;
import io.vproxy.vfx.control.dialog.VDialog;
import io.vproxy.vfx.control.dialog.VDialogButton;
import io.vproxy.vfx.control.globalscreen.GlobalScreenUtils;
import io.vproxy.vfx.entity.input.Key;
import io.vproxy.vfx.entity.input.KeyCode;
import io.vproxy.vfx.entity.input.MouseWheelScroll;
import io.vproxy.vfx.manager.internal_i18n.InternalI18n;
import java.util.ArrayList;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.input.MouseButton;

public class KeyChooser
extends VDialog<Key> {
    public static final int FLAG_WITH_MOUSE = 1;
    public static final int FLAG_WITH_WHEEL_SCROLL = 2;
    private final NativeKeyListener keyListener = new NativeKeyListener(){

        public void nativeKeyPressed(NativeKeyEvent e) {
            Key key;
            if (e.getKeyCode() == 29 || e.getKeyCode() == 56 || e.getKeyCode() == 42 || e.getKeyCode() == 3638) {
                boolean isLeft;
                if (e.getKeyLocation() == 2) {
                    isLeft = true;
                } else if (e.getKeyLocation() == 3) {
                    isLeft = false;
                } else {
                    return;
                }
                key = new Key(KeyCode.valueOf(e.getKeyCode()), isLeft);
            } else {
                if (e.getKeyLocation() == 4) {
                    return;
                }
                key = new Key(KeyCode.valueOf(e.getKeyCode()));
            }
            Platform.runLater(() -> {
                KeyChooser.this.returnValue = key;
                KeyChooser.this.getStage().close();
            });
        }
    };

    public KeyChooser() {
        this(1);
    }

    public KeyChooser(int flags) {
        ArrayList buttons = new ArrayList();
        if ((flags & 2) == 2) {
            buttons.add(new VDialogButton<Key>(InternalI18n.get().keyChooserWheelScrollUpButton(), new Key(new MouseWheelScroll(MouseWheelScroll.Direction.UP))));
            buttons.add(new VDialogButton<Key>(InternalI18n.get().keyChooserWheelScrollDownButton(), new Key(new MouseWheelScroll(MouseWheelScroll.Direction.DOWN))));
        }
        if ((flags & 1) == 1) {
            buttons.add(new VDialogButton<Key>(InternalI18n.get().keyChooserLeftMouseButton(), new Key(MouseButton.PRIMARY)));
            buttons.add(new VDialogButton<Key>(InternalI18n.get().keyChooserMiddleMouseButton(), new Key(MouseButton.MIDDLE)));
            buttons.add(new VDialogButton<Key>(InternalI18n.get().keyChooserRightMouseButton(), new Key(MouseButton.SECONDARY)));
        }
        buttons.add(new VDialogButton<Key>(InternalI18n.get().cancelButton(), () -> null));
        this.setButtons(buttons);
        boolean withMouse = (flags & 3) != 0;
        this.getMessageNode().setText(withMouse ? InternalI18n.get().keyChooserDesc() : InternalI18n.get().keyChooserDescWithoutMouse());
        if (buttons.size() > 4) {
            this.getStage().getStage().setWidth(1200.0);
        }
    }

    public Optional<Key> choose() {
        GlobalScreenUtils.enable(this);
        GlobalScreen.addNativeKeyListener((NativeKeyListener)this.keyListener);
        Optional<Key> ret = this.showAndWait();
        GlobalScreen.removeNativeKeyListener((NativeKeyListener)this.keyListener);
        GlobalScreenUtils.disable(this);
        return ret;
    }
}

