/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.component.logconsole;

import io.vproxy.base.util.Logger;
import io.vproxy.base.util.log.LogDispatcher;
import io.vproxy.base.util.log.LogHandler;
import io.vproxy.base.util.log.LogRecord;
import io.vproxy.vfx.control.scroll.ScrollDirection;
import io.vproxy.vfx.control.scroll.VScrollPane;
import io.vproxy.vfx.ui.pane.ClickableFusionPane;
import io.vproxy.vfx.ui.wrapper.ThemeLabel;
import io.vproxy.vfx.util.FXUtils;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

public class LogConsole {
    private final int preserveLogCount;
    private final int clearLogCount;
    private final VScrollPane pane;
    private final VBox vbox;
    private final LogHandler logHandler;
    private boolean alwaysScrollToEnd = true;

    public LogConsole() {
        this(200, 250);
    }

    public LogConsole(int preserveLogCount, int clearLogCount) {
        this(Logger.logDispatcher, preserveLogCount, clearLogCount);
    }

    public LogConsole(LogDispatcher logDispatcher, int preserveLogCount, int clearLogCount) {
        if (clearLogCount < preserveLogCount) {
            throw new IllegalArgumentException("clearLogCount = " + clearLogCount + " must not smaller than preserveLogCount = " + preserveLogCount);
        }
        this.preserveLogCount = preserveLogCount;
        this.clearLogCount = clearLogCount;
        this.pane = new VScrollPane();
        this.vbox = new VBox();
        this.vbox.setSpacing(5.0);
        FXUtils.observeWidth(this.pane.getNode(), (Region)this.vbox);
        this.pane.setContent((Node)this.vbox);
        this.logHandler = this::handleLog;
        logDispatcher.addLogHandler(this.logHandler);
        this.vbox.heightProperty().addListener((ob, old, now) -> {
            if (this.alwaysScrollToEnd) {
                Platform.runLater(() -> this.pane.setVvalue(1.0));
            }
        });
    }

    public boolean isAlwaysScrollToEnd() {
        return this.alwaysScrollToEnd;
    }

    public void setAlwaysScrollToEnd(boolean alwaysScrollToEnd) {
        this.alwaysScrollToEnd = alwaysScrollToEnd;
        if (alwaysScrollToEnd) {
            this.pane.setVvalue(1.0);
        }
    }

    private void handleLog(LogRecord record) {
        this.add(record.toStringNoColor());
    }

    private void add(String log) {
        FXUtils.runOnFX(() -> this.add0(log));
    }

    private void add0(String log0) {
        String log = log0.trim();
        ThemeLabel label = new ThemeLabel(log){
            {
                this.setFont(new Font("JetBrains Mono", 16.0));
            }
        };
        VScrollPane hscroll = new VScrollPane(ScrollDirection.NONE);
        hscroll.setContent((Node)label);
        FXUtils.observeHeight((Region)label, hscroll.getNode(), 2.0);
        ClickableFusionPane logPane = new ClickableFusionPane(false);
        logPane.setOnAction(e -> {
            ClipboardContent content = new ClipboardContent();
            content.putString(log);
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        logPane.getContentPane().getChildren().add((Object)hscroll.getNode());
        FXUtils.observeWidth(logPane.getNode(), hscroll.getNode(), -20.0);
        this.vbox.getChildren().add((Object)logPane.getNode());
        if (this.vbox.getChildren().size() > this.clearLogCount) {
            this.vbox.getChildren().remove(0, this.vbox.getChildren().size() - this.preserveLogCount);
        }
    }

    public Region getNode() {
        return this.pane.getNode();
    }
}

