/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.control.click;

import javafx.event.EventHandler;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public abstract class ClickEventHandler
implements EventHandler<MouseEvent> {
    protected boolean mouseEntered = false;
    protected boolean mousePressed = false;

    public void handle(MouseEvent e) {
        if (e.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.eventOnMouseEntered();
        } else if (e.getEventType() == MouseEvent.MOUSE_EXITED) {
            this.eventOnMouseExited();
        } else if (e.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.eventOnMousePressed(e);
        } else if (e.getEventType() == MouseEvent.MOUSE_RELEASED) {
            this.eventOnMouseReleased(e);
        }
    }

    public boolean isMouseEntered() {
        return this.mouseEntered;
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    private void eventOnMouseEntered() {
        this.mouseEntered = true;
        if (this.mousePressed) {
            return;
        }
        this.onMouseEntered();
    }

    private void eventOnMouseExited() {
        this.mouseEntered = false;
        if (this.mousePressed) {
            return;
        }
        this.onMouseExited();
    }

    private void eventOnMousePressed(MouseEvent e) {
        if (e.getButton() != MouseButton.PRIMARY) {
            return;
        }
        this.mousePressed = true;
        this.onMousePressed();
    }

    private void eventOnMouseReleased(MouseEvent e) {
        if (e.getButton() != MouseButton.PRIMARY) {
            return;
        }
        this.mousePressed = false;
        this.onMouseReleased();
        if (this.mouseEntered) {
            this.onMouseClicked();
        } else {
            this.onMouseExited();
        }
    }

    protected void onMouseEntered() {
    }

    protected void onMouseExited() {
    }

    protected void onMousePressed() {
    }

    protected void onMouseReleased() {
    }

    protected void onMouseClicked() {
    }
}

