/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.control.dialog;

import io.vproxy.vfx.control.dialog.VDialogButton;
import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.theme.Theme;
import io.vproxy.vfx.ui.button.FusionButton;
import io.vproxy.vfx.ui.layout.HPadding;
import io.vproxy.vfx.ui.layout.VPadding;
import io.vproxy.vfx.ui.pane.FusionPane;
import io.vproxy.vfx.ui.stage.VStage;
import io.vproxy.vfx.util.FXUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;

public class VDialog<T> {
    private static final int BUTTON_HEIGHT = 45;
    private static final int BUTTON_PANE_HEIGHT = 65;
    private final VStage stage = new VStage();
    private final Label messageLabel = new Label();
    private final Group content = new Group(new Node[]{this.messageLabel});
    private final FusionPane buttonPane = new FusionPane();
    private final HBox buttonHBox = new HBox();
    protected T returnValue;

    public VDialog() {
        this.stage.getStage().setWidth(900.0);
        this.stage.getStage().centerOnScreen();
        this.messageLabel.setWrapText(true);
        FontManager.get().setFont(FontUsages.dialogText, (Labeled)this.messageLabel);
        this.messageLabel.setTextFill((Paint)Theme.current().normalTextColor());
        this.buttonPane.getContentPane().getChildren().add((Object)this.buttonHBox);
        this.buttonPane.getNode().setPrefHeight(65.0);
        this.buttonHBox.setAlignment(Pos.CENTER_RIGHT);
        this.buttonHBox.setSpacing(5.0);
        FXUtils.observeWidth((Region)this.buttonPane.getContentPane(), (Region)this.buttonHBox);
        FXUtils.observeWidth(this.stage.getInitialScene().getScrollPane().getNode(), (Region)this.stage.getInitialScene().getContentPane(), -1.0);
        Pane root = this.stage.getInitialScene().getContentPane();
        root.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double w = now.doubleValue();
            this.messageLabel.setPrefWidth(w - 20.0);
            this.buttonPane.getNode().setPrefWidth(w - 20.0);
        });
        root.heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double h = now.doubleValue();
            h = 28.0 + h + 10.0;
            this.stage.getStage().setHeight(h);
        });
        FXUtils.forceUpdate(this.stage.getStage());
        root.getChildren().add((Object)new HBox(new Node[]{new HPadding(10.0), new VBox(new Node[]{new VPadding(10.0), this.content, new VPadding(10.0), this.buttonPane.getNode()})}));
    }

    public void setText(String text) {
        this.messageLabel.setText(text);
    }

    public Label getMessageNode() {
        return this.messageLabel;
    }

    public void setButtons(List<VDialogButton<T>> buttons) {
        this.buttonHBox.getChildren().clear();
        ArrayList<FusionButton> ls = new ArrayList<FusionButton>();
        for (VDialogButton<T> btn : buttons) {
            String name = btn.name;
            FusionButton button = new FusionButton(name);
            Rectangle2D textBounds = FXUtils.calculateTextBounds(button.getTextNode());
            button.setPrefWidth(Math.max(textBounds.getWidth() + 40.0, 120.0));
            button.setPrefHeight(45.0);
            ls.add(button);
            button.setOnAction(e -> {
                if (btn.provider != null) {
                    this.returnValue = btn.provider.get();
                }
                this.onButtonClicked(btn);
                this.stage.close();
            });
            btn.button = button;
        }
        this.buttonHBox.getChildren().addAll(ls);
    }

    public Group getCleanContent() {
        this.content.getChildren().remove((Object)this.messageLabel);
        return this.content;
    }

    protected void onButtonClicked(VDialogButton<T> btn) {
    }

    public Optional<T> showAndWait() {
        this.stage.showAndWait();
        this.getStage().temporaryOnTop();
        return Optional.ofNullable(this.returnValue);
    }

    public VStage getStage() {
        return this.stage;
    }
}

