/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.control.drag;

import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;

public abstract class DragHandler
implements EventHandler<MouseEvent> {
    private double oldNodeX;
    private double oldNodeY;
    private double oldOffsetX;
    private double oldOffsetY;

    protected abstract void set(double var1, double var3);

    protected abstract double[] get();

    protected double[] getOffset(MouseEvent e) {
        return new double[]{e.getScreenX(), e.getScreenY()};
    }

    public void handle(MouseEvent e) {
        if (e.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.pressed(e);
        } else if (e.getEventType() == MouseEvent.MOUSE_DRAGGED) {
            this.dragged(e);
            this.consume(e);
        }
    }

    protected void consume(MouseEvent e) {
    }

    protected void pressed(MouseEvent e) {
        double[] xy = this.get();
        this.oldNodeX = xy[0];
        this.oldNodeY = xy[1];
        double[] offxy = this.getOffset(e);
        this.oldOffsetX = offxy[0];
        this.oldOffsetY = offxy[1];
    }

    protected void dragged(MouseEvent e) {
        double[] offxy = this.getOffset(e);
        double deltaX = offxy[0] - this.oldOffsetX;
        double deltaY = offxy[1] - this.oldOffsetY;
        double x = this.calculateDeltaX(deltaX, deltaY) + this.oldNodeX;
        double y = this.calculateDeltaY(deltaX, deltaY) + this.oldNodeY;
        this.set(x, y);
    }

    protected double calculateDeltaX(double deltaX, double deltaY) {
        return deltaX;
    }

    protected double calculateDeltaY(double deltaX, double deltaY) {
        return deltaY;
    }
}

