/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.control.drag;

import javafx.animation.AnimationTimer;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public abstract class WSADMovingHandler
implements EventHandler<KeyEvent> {
    private final double xSpeed;
    private final double ySpeed;
    private long time;
    private boolean w;
    private boolean s;
    private boolean wsIsW;
    private boolean a;
    private boolean d;
    private boolean adIsA;
    private AnimationTimer timer = null;
    private double x;
    private double y;

    public WSADMovingHandler(double xSpeed, double ySpeed) {
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;
    }

    public void handle(KeyEvent event) {
        if (event.getEventType() == KeyEvent.KEY_PRESSED) {
            this.onPressed(event.getCode());
        } else if (event.getEventType() == KeyEvent.KEY_RELEASED) {
            this.onReleased(event.getCode());
        }
    }

    private void onPressed(KeyCode code) {
        switch (code) {
            case W: {
                if (this.w) break;
                this.w = true;
                this.wsIsW = true;
                this.record();
                break;
            }
            case S: {
                if (this.s) break;
                this.s = true;
                this.wsIsW = false;
                this.record();
                break;
            }
            case A: {
                if (this.a) break;
                this.a = true;
                this.adIsA = true;
                this.record();
                break;
            }
            case D: {
                if (this.d) break;
                this.d = true;
                this.adIsA = false;
                this.record();
                break;
            }
            default: {
                return;
            }
        }
        if ((this.w || this.s || this.a || this.d) && this.timer == null) {
            this.timer = new Timer();
            this.timer.start();
        }
    }

    private void record() {
        this.time = System.nanoTime();
        double[] xy = this.get();
        this.x = xy[0];
        this.y = xy[1];
    }

    private void onReleased(KeyCode code) {
        switch (code) {
            case W: {
                if (!this.w) break;
                this.w = false;
                this.wsIsW = false;
                this.record();
                break;
            }
            case S: {
                if (!this.s) break;
                this.s = false;
                this.wsIsW = true;
                this.record();
                break;
            }
            case A: {
                if (!this.a) break;
                this.a = false;
                this.adIsA = false;
                this.record();
                break;
            }
            case D: {
                if (!this.d) break;
                this.d = false;
                this.adIsA = true;
                this.record();
                break;
            }
            default: {
                return;
            }
        }
        if (!(this.w || this.s || this.a || this.d)) {
            AnimationTimer timer = this.timer;
            this.timer = null;
            if (timer != null) {
                timer.stop();
            }
        }
        if (!(this.w || this.s || this.a || this.d)) {
            this.time = 0L;
        }
    }

    protected abstract void set(double var1, double var3);

    protected abstract double[] get();

    private class Timer
    extends AnimationTimer {
        private Timer() {
        }

        public void handle(long now) {
            if (WSADMovingHandler.this.time == 0L) {
                return;
            }
            long delta = now - WSADMovingHandler.this.time;
            if (delta < 0L) {
                return;
            }
            double x = WSADMovingHandler.this.x;
            double y = WSADMovingHandler.this.y;
            if (WSADMovingHandler.this.w || WSADMovingHandler.this.s) {
                y = WSADMovingHandler.this.wsIsW ? (y -= WSADMovingHandler.this.ySpeed * (double)delta / 1000000.0) : (y += WSADMovingHandler.this.ySpeed * (double)delta / 1000000.0);
            }
            if (WSADMovingHandler.this.a || WSADMovingHandler.this.d) {
                x = WSADMovingHandler.this.adIsA ? (x -= WSADMovingHandler.this.xSpeed * (double)delta / 1000000.0) : (x += WSADMovingHandler.this.xSpeed * (double)delta / 1000000.0);
            }
            WSADMovingHandler.this.set(x, y);
        }
    }
}

