/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.control.globalscreen;

import com.github.kwhat.jnativehook.GlobalScreen;
import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.base.util.OS;
import io.vproxy.vfx.manager.internal_i18n.InternalI18n;
import io.vproxy.vfx.ui.alert.StackTraceAlert;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.application.Platform;

public class GlobalScreenUtils {
    private static final Map<Object, Integer> enableKeys = new HashMap<Object, Integer>();

    private GlobalScreenUtils() {
    }

    public static void releaseJNativeHookNativeToLibraryPath(InputStream inputStream) {
        GlobalScreenUtils.releaseJNativeHookNativeToLibraryPath(inputStream, Stream::findAny);
    }

    public static void releaseJNativeHookNativeToLibraryPath(InputStream inputStream, Function<Stream<File>, Optional<File>> selectFunc) {
        String suffix = OS.isWindows() ? ".dll" : (OS.isMac() ? ".dylib" : ".so");
        String javaLibraryPath = System.getProperty("java.library.path", "");
        String soname = "vfx-extracted-JNativeHook";
        Logger.alert((String)("java.library.path: " + javaLibraryPath));
        Logger.alert((String)("dynamic library name: " + soname));
        Stream<File> stream = Arrays.stream(javaLibraryPath.split(File.pathSeparator)).filter(s -> !s.isBlank()).map(File::new).filter(File::isDirectory);
        Optional<File> libpathFile = selectFunc.apply(stream);
        if (libpathFile.isEmpty()) {
            Logger.warn((LogType)LogType.INVALID_INPUT_DATA, (String)"no available directory in java.library.path");
            return;
        }
        try {
            String prefix = suffix.endsWith(".dll") ? "" : "lib";
            File f = Path.of(libpathFile.get().getAbsolutePath(), prefix + soname + suffix).toFile();
            if (f.exists()) {
                Logger.alert((String)("JNativeHook tmp dynamic library already exists: " + f.getAbsolutePath()));
                f.setExecutable(true);
                GlobalScreenUtils.setJNativeHookLib(soname);
                return;
            }
            boolean ok2 = f.createNewFile();
            if (!ok2) {
                Logger.error((LogType)LogType.FILE_ERROR, (String)("failed creating tmp file: " + f.getAbsolutePath()));
                return;
            }
            f.setExecutable(true);
            GlobalScreenUtils.setJNativeHookLib(soname);
            try (InputStream ok2 = inputStream;
                 FileOutputStream fos = new FileOutputStream(f);){
                int n;
                byte[] buf = new byte[131072];
                while ((n = inputStream.read(buf)) != -1) {
                    fos.write(buf, 0, n);
                }
            }
            catch (IOException e) {
                Logger.error((LogType)LogType.FILE_ERROR, (String)"extracting jnative hook native library failed", (Throwable)e);
            }
        }
        catch (IOException e) {
            Logger.error((LogType)LogType.FILE_ERROR, (String)"creating tmp file for jnative hook libs failed", (Throwable)e);
        }
    }

    private static void setJNativeHookLib(String soname) {
        String key = "jnativehook.lib.name";
        Logger.alert((String)("setting system property: " + key + " => " + soname));
        System.setProperty(key, soname);
    }

    public static synchronized void enable(Object key) {
        block5: {
            Integer n = enableKeys.get(key);
            if (n == null) {
                n = 0;
            }
            n = n + 1;
            enableKeys.put(key, n);
            if (enableKeys.size() == 1 && n == 1) {
                assert (Logger.lowLevelDebug((String)"register GlobalScreen"));
                try {
                    GlobalScreen.registerNativeHook();
                }
                catch (Throwable e) {
                    Logger.error((LogType)LogType.SYS_ERROR, (String)"failed to register GlobalScreen", (Throwable)e);
                    if (!Platform.isFxApplicationThread()) break block5;
                    StackTraceAlert.show(InternalI18n.get().globalScreenRegisterFailed(), e);
                }
            }
        }
    }

    public static synchronized void disable(Object key) {
        Integer n = enableKeys.get(key);
        if (n == null) {
            Logger.error((LogType)LogType.IMPROPER_USE, (String)("GlobalScreenUtils.disable is called with " + key + ", but it's not enabled with this key before"));
            return;
        }
        if ((n = Integer.valueOf(n - 1)) == 0) {
            enableKeys.remove(key);
            if (enableKeys.isEmpty()) {
                GlobalScreenUtils.unregister();
            }
        } else {
            enableKeys.put(key, n);
        }
    }

    public static void unregister() {
        assert (Logger.lowLevelDebug((String)"unregister GlobalScreen"));
        try {
            GlobalScreen.unregisterNativeHook();
            GlobalScreen.setEventDispatcher(null);
        }
        catch (Throwable e) {
            Logger.error((LogType)LogType.SYS_ERROR, (String)"failed to unregister GlobalScreen", (Throwable)e);
        }
    }
}

