/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.control.scroll;

import io.vproxy.vfx.animation.AnimationGraph;
import io.vproxy.vfx.animation.AnimationGraphBuilder;
import io.vproxy.vfx.animation.AnimationNode;
import io.vproxy.vfx.control.drag.DragHandler;
import io.vproxy.vfx.control.scroll.HorizontalScrollBarImpl;
import io.vproxy.vfx.control.scroll.NodeWithVScrollPane;
import io.vproxy.vfx.control.scroll.ScrollDirection;
import io.vproxy.vfx.control.scroll.VerticalScrollBarImpl;
import io.vproxy.vfx.control.scroll.Viewport;
import io.vproxy.vfx.util.FXUtils;
import io.vproxy.vfx.util.algebradata.DoubleData;
import javafx.beans.property.DoubleProperty;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class VScrollPane
implements NodeWithVScrollPane {
    public static final int SCROLL_WIDTH = 4;
    public static final int SCROLL_PADDING = 2;
    private static final int SCROLL_MIN_LENGTH = 25;
    private double scrollSpeed = 5.0;
    private final Pane root = new Pane();
    private final Viewport viewport = new Viewport();
    private final VerticalScrollBarImpl scrollBarV = new VerticalScrollBarImpl(){
        {
            this.setMouseTransparent(true);
        }
    };
    private final HorizontalScrollBarImpl scrollBarH = new HorizontalScrollBarImpl(){
        {
            this.setMouseTransparent(true);
        }
    };
    private Double verticalScrollBarLayoutX;
    private Double horizontalScrollBarLayoutY;
    private final AnimationNode<DoubleData> animationHide = new AnimationNode<DoubleData>("hide", new DoubleData(0.0));
    private final AnimationNode<DoubleData> animationShow = new AnimationNode<DoubleData>("show", new DoubleData(1.0));
    private final AnimationGraph<DoubleData> animationHideShow = AnimationGraphBuilder.simpleTwoNodeGraph(this.animationHide, this.animationShow, 300L).setApply((from, to, d) -> {
        this.scrollBarV.setOpacity(d.value);
        this.scrollBarH.setOpacity(d.value);
    }).build(this.animationHide);
    private ScrollDirection scrollDirection;

    public VScrollPane() {
        this(ScrollDirection.VERTICAL);
    }

    public VScrollPane(ScrollDirection scrollDirection0) {
        this.scrollDirection = scrollDirection0;
        this.viewport.getNode().setOnScroll(e -> {
            double ll;
            if (this.scrollDirection == ScrollDirection.NONE) {
                return;
            }
            double d = ll = this.scrollDirection == ScrollDirection.HORIZONTAL ? this.viewport.getContentWidth() : this.viewport.getContentHeight();
            if (ll == 0.0) {
                return;
            }
            if (this.scrollDirection == ScrollDirection.HORIZONTAL ? ll <= this.root.getWidth() : ll <= this.root.getHeight()) {
                return;
            }
            double dd = e.getDeltaY() * this.scrollSpeed / ll;
            if (this.scrollDirection == ScrollDirection.HORIZONTAL) {
                this.setHvalue(this.getHvalue() - dd);
            } else {
                this.setVvalue(this.getVvalue() - dd);
            }
            e.consume();
        });
        DragHandler dragScrollHandler = new DragHandler(){

            @Override
            protected void set(double x, double y) {
                VScrollPane.this.setHpos(x);
                VScrollPane.this.setVpos(y);
            }

            @Override
            protected double[] get() {
                return new double[]{VScrollPane.this.viewport.getHpos(), VScrollPane.this.viewport.getVpos()};
            }
        };
        this.viewport.getNode().setOnMousePressed((EventHandler)dragScrollHandler);
        this.viewport.getNode().setOnMouseDragged((EventHandler)dragScrollHandler);
        this.root.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double w = now.doubleValue();
            this.viewport.getNode().setPrefWidth(w);
            this.updateScrollHWidthAndPosition();
            if (this.verticalScrollBarLayoutX == null) {
                this.scrollBarV.setLayoutX(w - 4.0 - 2.0);
            } else {
                this.scrollBarH.setLayoutX(this.verticalScrollBarLayoutX);
            }
        });
        this.root.heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double h = now.doubleValue();
            this.viewport.getNode().setPrefHeight(h);
            this.updateScrollVHeightAndPosition();
            if (this.horizontalScrollBarLayoutY == null) {
                this.scrollBarH.setLayoutY(h - 4.0 - 2.0);
            } else {
                this.scrollBarH.setLayoutY(this.horizontalScrollBarLayoutY);
            }
        });
        this.root.getChildren().addAll((Object[])new Node[]{this.viewport.getNode(), this.scrollBarV, this.scrollBarH});
        this.root.setOnMouseEntered(e -> this.animationHideShow.play(this.animationShow));
        this.root.setOnMouseExited(e -> this.animationHideShow.play(this.animationHide));
    }

    private void updateScrollVHeightAndPosition() {
        double h = this.root.getHeight();
        if (h == 0.0) {
            return;
        }
        Node content = this.viewport.getContent();
        if (content == null) {
            this.scrollBarV.setVisible(false);
            return;
        }
        Bounds bounds = content.getLayoutBounds();
        if (bounds.getHeight() <= h) {
            this.scrollBarV.setVisible(false);
            return;
        }
        double p = h / bounds.getHeight();
        double length = p * h;
        if (length < 25.0) {
            length = 25.0;
        }
        this.scrollBarV.setLength(length);
        this.updateScrollVPosition(h, length);
        this.scrollBarV.setVisible(true);
    }

    private void updateScrollVPosition() {
        double h = this.root.getHeight();
        if (h == 0.0) {
            return;
        }
        this.updateScrollVPosition(h, this.scrollBarV.getLength());
    }

    private void updateScrollVPosition(double scrollPaneHeight, double scrollBarLength) {
        double p = this.getVvalue();
        double y = (scrollPaneHeight - scrollBarLength) * p;
        this.scrollBarV.setLayoutY(y);
    }

    private void updateScrollHWidthAndPosition() {
        double w = this.root.getWidth();
        if (w == 0.0) {
            return;
        }
        Node content = this.viewport.getContent();
        if (content == null) {
            this.scrollBarH.setVisible(false);
            return;
        }
        Bounds bounds = content.getLayoutBounds();
        if (bounds.getWidth() <= w) {
            this.scrollBarH.setVisible(false);
            return;
        }
        double p = w / bounds.getWidth();
        double length = p * w;
        if (length < 25.0) {
            length = 25.0;
        }
        this.scrollBarH.setLength(length);
        this.updateScrollHPosition(w, length);
        this.scrollBarH.setVisible(true);
    }

    private void updateScrollHPosition() {
        double w = this.root.getWidth();
        if (w == 0.0) {
            return;
        }
        this.updateScrollHPosition(w, this.scrollBarH.getLength());
    }

    private void updateScrollHPosition(double scrollPaneWidth, double scrollBarLength) {
        double p = this.getHvalue();
        double x = (scrollPaneWidth - scrollBarLength) * p;
        this.scrollBarH.setLayoutX(x);
    }

    public double getScrollSpeed() {
        return this.scrollSpeed;
    }

    public void setScrollSpeed(double scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    public Region getNode() {
        return this.root;
    }

    public double getVvalue() {
        return this.viewport.getVvalue();
    }

    public double getHvalue() {
        return this.viewport.getHvalue();
    }

    public void setVvalue(double vvalue) {
        this.viewport.setVvalue(vvalue);
        this.updateScrollVPosition();
    }

    public void setHvalue(double hvalue) {
        this.viewport.setHvalue(hvalue);
        this.updateScrollHPosition();
    }

    public DoubleProperty vposProperty() {
        return this.viewport.vposProperty();
    }

    public double getVpos() {
        return this.viewport.getVpos();
    }

    public void setVpos(double vpos) {
        this.viewport.setVpos(vpos);
        this.updateScrollVPosition();
    }

    public DoubleProperty hposProperty() {
        return this.viewport.hposProperty();
    }

    public double getHpos() {
        return this.viewport.getHpos();
    }

    public void setHpos(double hpos) {
        this.viewport.setHpos(hpos);
        this.updateScrollHPosition();
    }

    public void setContent(Node node) {
        this.viewport.setContent(node);
        node.layoutBoundsProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.updateScrollVHeightAndPosition();
            this.updateScrollHWidthAndPosition();
        });
    }

    public void setVerticalScrollBarLayoutX(Double verticalScrollBarLayoutX) {
        this.verticalScrollBarLayoutX = verticalScrollBarLayoutX;
        this.scrollBarV.setLayoutX(verticalScrollBarLayoutX);
    }

    public void setHorizontalScrollBarLayoutY(Double horizontalScrollBarLayoutY) {
        this.horizontalScrollBarLayoutY = horizontalScrollBarLayoutY;
        this.scrollBarH.setLayoutY(horizontalScrollBarLayoutY);
    }

    public ScrollDirection getScrollDirection() {
        return this.scrollDirection;
    }

    public void setScrollDirection(ScrollDirection scrollDirection) {
        this.scrollDirection = scrollDirection;
    }

    @Override
    public VScrollPane getScrollPane() {
        return this;
    }

    @Override
    public Region getSelfNode() {
        return this.getNode();
    }

    public static VScrollPane makeHorizontalScrollPaneToManage(NodeWithVScrollPane node) {
        VScrollPane pane = new VScrollPane(ScrollDirection.HORIZONTAL);
        pane.setContent((Node)node.getSelfNode());
        Runnable update = () -> node.getScrollPane().setVerticalScrollBarLayoutX(-pane.getHpos() + pane.getNode().getWidth() - 4.0 - 2.0);
        pane.getNode().widthProperty().addListener((ob, old, now) -> update.run());
        pane.hposProperty().addListener((ob, old, now) -> update.run());
        FXUtils.observeHeight(node.getSelfNode(), pane.getNode());
        return pane;
    }
}

