/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.control.scroll;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class Viewport {
    private final Pane root = new Pane();
    private final Group container = new Group();
    private double lastContentHeight = 0.0;
    private double lastContentWidth = 0.0;
    private final DoublePropertyBase vposProperty = new DoublePropertyBase(this.getVpos()){
        {
            Viewport.this.container.layoutYProperty().addListener((ob, old, now) -> {
                if (now == null) {
                    return;
                }
                this.set(now.doubleValue());
            });
        }

        protected void invalidated() {
            Viewport.this.setVpos(Viewport.this.vposProperty.get());
        }

        public Object getBean() {
            return Viewport.this;
        }

        public String getName() {
            return "vposProperty";
        }
    };
    private final DoublePropertyBase hposProperty = new DoublePropertyBase(this.getHpos()){
        {
            Viewport.this.container.layoutXProperty().addListener((ob, old, now) -> {
                if (now == null) {
                    return;
                }
                this.set(now.doubleValue());
            });
        }

        protected void invalidated() {
            Viewport.this.setHpos(Viewport.this.hposProperty.get());
        }

        public Object getBean() {
            return Viewport.this;
        }

        public String getName() {
            return "hposProperty";
        }
    };

    public Viewport() {
        Rectangle cut = new Rectangle();
        this.root.setClip((Node)cut);
        this.root.widthProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double w = now.doubleValue();
            cut.setWidth(w);
            this.updateHPos();
        });
        this.root.heightProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            double h = now.doubleValue();
            cut.setHeight(h);
            this.updateVPos();
        });
        this.root.getChildren().add((Object)this.container);
    }

    private void updateVPos() {
        if (this.container.getChildren().isEmpty()) {
            return;
        }
        double height = this.lastContentHeight;
        double viewportH = this.root.getHeight();
        if (viewportH >= height) {
            this.container.setLayoutY(0.0);
            return;
        }
        double y = this.container.getLayoutY();
        if (height - viewportH + y < 0.0) {
            this.container.setLayoutY(viewportH - height);
        }
    }

    public double getVvalue() {
        if (this.container.getChildren().isEmpty()) {
            return 0.0;
        }
        double height = this.lastContentHeight;
        double viewportH = this.root.getHeight();
        double y = this.container.getLayoutY();
        if (y == 0.0) {
            return 0.0;
        }
        if (viewportH >= height) {
            return 0.0;
        }
        return -y / (height - viewportH);
    }

    public void setVvalue(double vvalue) {
        if (this.container.getChildren().isEmpty()) {
            return;
        }
        if (vvalue < 0.0) {
            this.container.setLayoutY(0.0);
            return;
        }
        if (vvalue > 1.0) {
            vvalue = 1.0;
        }
        Node content = (Node)this.container.getChildren().get(0);
        Bounds bounds = content.getLayoutBounds();
        double height = bounds.getHeight();
        double viewportH = this.root.getHeight();
        if (viewportH >= height) {
            return;
        }
        double y = (height - viewportH) * vvalue;
        this.container.setLayoutY(-y);
    }

    private void updateHPos() {
        if (this.container.getChildren().isEmpty()) {
            return;
        }
        double width = this.lastContentWidth;
        double viewportW = this.root.getWidth();
        if (viewportW >= width) {
            this.container.setLayoutX(0.0);
            return;
        }
        double x = this.container.getLayoutX();
        if (width - viewportW + x < 0.0) {
            this.container.setLayoutX(viewportW - width);
        }
    }

    public double getHvalue() {
        if (this.container.getChildren().isEmpty()) {
            return 0.0;
        }
        double width = this.lastContentWidth;
        double viewportW = this.root.getWidth();
        double x = this.container.getLayoutX();
        if (x == 0.0) {
            return 0.0;
        }
        if (viewportW >= width) {
            return 0.0;
        }
        return -x / (width - viewportW);
    }

    public void setHvalue(double hvalue) {
        if (this.container.getChildren().isEmpty()) {
            return;
        }
        if (hvalue < 0.0) {
            this.container.setLayoutX(0.0);
            return;
        }
        if (hvalue > 1.0) {
            hvalue = 1.0;
        }
        Node content = (Node)this.container.getChildren().get(0);
        Bounds bounds = content.getLayoutBounds();
        double width = bounds.getWidth();
        double viewportW = this.root.getWidth();
        if (viewportW >= width) {
            return;
        }
        double x = (width - viewportW) * hvalue;
        this.container.setLayoutX(-x);
    }

    public DoubleProperty vposProperty() {
        return this.vposProperty;
    }

    public double getVpos() {
        return this.container.getLayoutY();
    }

    public void setVpos(double vpos) {
        Node content = (Node)this.container.getChildren().get(0);
        Bounds bounds = content.getLayoutBounds();
        double height = bounds.getHeight();
        double viewportH = this.root.getHeight();
        if (vpos < viewportH - height) {
            vpos = viewportH - height;
        }
        if (vpos > 0.0) {
            vpos = 0.0;
        }
        this.vposProperty.set(vpos);
        this.container.setLayoutY(vpos);
    }

    public DoubleProperty hposProperty() {
        return this.hposProperty;
    }

    public double getHpos() {
        return this.container.getLayoutX();
    }

    public void setHpos(double hpos) {
        Node content = (Node)this.container.getChildren().get(0);
        Bounds bounds = content.getLayoutBounds();
        double width = bounds.getWidth();
        double viewportW = this.root.getWidth();
        if (hpos < viewportW - width) {
            hpos = viewportW - width;
        }
        if (hpos > 0.0) {
            hpos = 0.0;
        }
        this.hposProperty.set(hpos);
        this.container.setLayoutX(hpos);
    }

    public void setContent(Node node) {
        if (node == null) {
            if (!this.container.getChildren().isEmpty()) {
                this.container.getChildren().remove(0);
            }
            return;
        }
        if (this.container.getChildren().isEmpty()) {
            this.container.getChildren().add((Object)node);
        } else {
            this.container.getChildren().set(0, (Object)node);
        }
        node.layoutBoundsProperty().addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            this.lastContentHeight = now.getHeight();
            this.lastContentWidth = now.getWidth();
            this.updateVPos();
            this.updateHPos();
        });
        this.lastContentHeight = node.getLayoutBounds().getHeight();
        this.lastContentWidth = node.getLayoutBounds().getWidth();
        this.updateVPos();
        this.updateHPos();
    }

    public Region getNode() {
        return this.root;
    }

    public Node getContent() {
        if (this.container.getChildren().isEmpty()) {
            return null;
        }
        return (Node)this.container.getChildren().get(0);
    }

    public double getContentHeight() {
        return this.lastContentHeight;
    }

    public double getContentWidth() {
        return this.lastContentWidth;
    }
}

