/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.entity;

import vjson.JSON;
import vjson.deserializer.rule.DoubleRule;
import vjson.deserializer.rule.ObjectRule;
import vjson.deserializer.rule.Rule;
import vjson.util.ObjectBuilder;

public class Point {
    public double x;
    public double y;
    public static final Rule<Point> rule = new ObjectRule(Point::new).put("x", (o, it) -> {
        o.x = it;
    }, (Rule)DoubleRule.get()).put("y", (o, it) -> {
        o.y = it;
    }, (Rule)DoubleRule.get());

    public Point() {
    }

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Point midOf(Point a, Point b) {
        return new Point((a.x + b.x) / 2.0, (a.y + b.y) / 2.0);
    }

    public JSON.Object toJson() {
        return new ObjectBuilder().put("x", this.x).put("y", this.y).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        if (Double.compare(point.x, this.x) != 0) {
            return false;
        }
        return Double.compare(point.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

