/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.entity.input;

import io.vproxy.vfx.entity.input.Key;
import io.vproxy.vfx.entity.input.KeyCode;
import java.util.Set;
import javafx.scene.input.MouseButton;
import vjson.JSON;
import vjson.deserializer.rule.BoolRule;
import vjson.deserializer.rule.ObjectRule;
import vjson.deserializer.rule.Rule;
import vjson.deserializer.rule.StringRule;
import vjson.util.ObjectBuilder;

public class InputData {
    public boolean ctrl;
    public boolean alt;
    public boolean shift;
    public Key key;
    public static final Rule<InputData> rule = new ObjectRule(InputData::new).put("ctrl", (o, it) -> {
        o.ctrl = it;
    }, (Rule)BoolRule.get()).put("alt", (o, it) -> {
        o.alt = it;
    }, (Rule)BoolRule.get()).put("shift", (o, it) -> {
        o.shift = it;
    }, (Rule)BoolRule.get()).put("key", (o, it) -> {
        o.key = new Key((String)it);
    }, (Rule)StringRule.get());

    public InputData() {
    }

    public InputData(InputData data) {
        this.ctrl = data.ctrl;
        this.alt = data.alt;
        this.shift = data.shift;
        this.key = data.key;
    }

    public InputData(boolean ctrl, boolean alt, boolean shift, Key key) {
        this.ctrl = ctrl;
        this.alt = alt;
        this.shift = shift;
        this.key = key;
    }

    public InputData(Key key) {
        this(false, false, false, key);
    }

    public boolean matches(Set<KeyCode> keys, Set<MouseButton> buttons, KeyCode currentKey, MouseButton currentMouse) {
        if (this.ctrl && !keys.contains((Object)KeyCode.CONTROL)) {
            return false;
        }
        if (this.alt && !keys.contains((Object)KeyCode.ALT)) {
            return false;
        }
        if (this.shift && !keys.contains((Object)KeyCode.SHIFT)) {
            return false;
        }
        if (this.key.key != null) {
            return this.key.key == currentKey;
        }
        if (this.key.button != null) {
            return this.key.button == currentMouse;
        }
        if (currentKey == KeyCode.CONTROL) {
            return this.ctrl;
        }
        if (currentKey == KeyCode.ALT) {
            return this.alt;
        }
        if (currentKey == KeyCode.SHIFT) {
            return this.shift;
        }
        return false;
    }

    public JSON.Object toJson() {
        ObjectBuilder ob = new ObjectBuilder().put("ctrl", this.ctrl).put("alt", this.alt).put("shift", this.shift);
        if (this.key != null) {
            ob.put("key", this.key.toString());
        }
        return ob.build();
    }
}

