/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.entity.input;

import io.vproxy.vfx.entity.input.KeyCode;
import io.vproxy.vfx.entity.input.MouseWheelScroll;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.scene.input.MouseButton;
import vjson.JSON;
import vjson.JSONObject;
import vjson.deserializer.rule.BoolRule;
import vjson.deserializer.rule.ObjectRule;
import vjson.deserializer.rule.Rule;
import vjson.deserializer.rule.StringRule;
import vjson.util.ObjectBuilder;

public class Key
implements JSONObject {
    public final MouseButton button;
    public final MouseWheelScroll scroll;
    public final KeyCode key;
    public final boolean isLeftKey;
    public final String raw;
    public static final Rule<Key> rule = ObjectRule.builder(() -> new KeyBuilder(), KeyBuilder::build, builder -> builder.put("button", (o, it) -> {
        o.button = MouseButton.valueOf((String)it);
    }, (Rule)StringRule.get()).put("scroll", (o, it) -> {
        o.scroll = it;
    }, MouseWheelScroll.rule).put("key", (o, it) -> {
        o.key = KeyCode.valueOf(it);
    }, (Rule)StringRule.get()).put("isLeftKey", (o, it) -> {
        o.isLeftKey = it;
    }, (Rule)BoolRule.get()).put("raw", (o, it) -> {
        o.raw = it;
    }, (Rule)StringRule.get()));
    private static final Map<String, MouseButton> stringToMouseButtonMap;
    private static final Map<MouseButton, String> mouseButtonToStringMap;
    private static final Map<KeyCode, String> keyCodeToStringMap;
    private static final Map<String, KeyCode> stringToKeyCodeMap;
    private static final Set<KeyCode> requireLeftRightKeys;
    private static final Set<String> hasLeftRightStrings;

    public Key(String raw) {
        this.raw = raw;
        this.button = Key.formatButton(raw);
        this.scroll = Key.formatScroll(raw);
        this.key = Key.formatKey(raw);
        this.isLeftKey = Key.checkIsLeftKey(raw);
    }

    public Key(MouseButton button) {
        this.button = button;
        this.scroll = null;
        this.key = null;
        this.isLeftKey = false;
        this.raw = this.toString(button, null, null, false);
    }

    public Key(MouseWheelScroll scroll) {
        this.button = null;
        this.scroll = scroll;
        this.key = null;
        this.isLeftKey = false;
        this.raw = this.toString(null, scroll, null, false);
    }

    public Key(KeyCode key) {
        this.button = null;
        this.scroll = null;
        this.key = key;
        this.isLeftKey = false;
        this.raw = this.toString(null, null, key, false);
    }

    public Key(KeyCode key, boolean isLeftKey) {
        this.button = null;
        this.scroll = null;
        this.key = key;
        this.isLeftKey = isLeftKey;
        this.raw = this.toString(null, null, key, isLeftKey);
    }

    public boolean isValid() {
        return this.toString(this.button, this.scroll, this.key, this.isLeftKey) != null;
    }

    private static MouseButton formatButton(String raw) {
        return stringToMouseButtonMap.get(raw.toLowerCase());
    }

    private static MouseWheelScroll formatScroll(String raw) {
        int v;
        MouseWheelScroll.Direction d;
        String val;
        String dir;
        if (!raw.startsWith("scroll-")) {
            return null;
        }
        if ((raw = raw.substring("scroll-".length())).contains(":")) {
            String[] split = raw.split(":");
            if (split.length != 2) {
                return null;
            }
            dir = split[0];
            val = split[1];
        } else {
            dir = raw;
            val = "0";
        }
        try {
            d = MouseWheelScroll.Direction.valueOf(dir.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        try {
            v = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new MouseWheelScroll(d, v);
    }

    private static KeyCode formatKey(String raw) {
        return stringToKeyCodeMap.get(raw.toLowerCase());
    }

    private static boolean checkIsLeftKey(String raw) {
        return hasLeftRightStrings.contains(raw = raw.toLowerCase()) && raw.startsWith("left");
    }

    private String toString(MouseButton button, MouseWheelScroll scroll, KeyCode key, boolean isLeftKey) {
        Object ret = null;
        if (button != null) {
            ret = mouseButtonToStringMap.get(button);
        } else if (scroll != null) {
            ret = scroll.toString();
        } else if (key != null && (ret = keyCodeToStringMap.get((Object)key)) != null && requireLeftRightKeys.contains((Object)key)) {
            ret = (isLeftKey ? "Left" : "Right") + (String)ret;
        }
        return ret;
    }

    public String toString() {
        String ret = this.toString(this.button, this.scroll, this.key, this.isLeftKey);
        if (ret == null) {
            ret = this.raw;
        }
        if (ret == null) {
            ret = "Unknown";
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key1 = (Key)o;
        if (this.isLeftKey != key1.isLeftKey) {
            return false;
        }
        if (this.button != key1.button) {
            return false;
        }
        if (this.key != key1.key) {
            return false;
        }
        return Objects.equals(this.raw, key1.raw);
    }

    public int hashCode() {
        int result = this.button != null ? this.button.hashCode() : 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.isLeftKey ? 1 : 0);
        result = 31 * result + (this.raw != null ? this.raw.hashCode() : 0);
        return result;
    }

    public JSON.Object toJson() {
        ObjectBuilder ob = new ObjectBuilder();
        if (this.button != null) {
            ob.put("button", this.button.name());
        }
        if (this.scroll != null) {
            ob.putInst("scroll", (JSON.Instance)this.scroll.toJson());
        }
        if (this.key != null) {
            ob.put("key", this.key.name());
            ob.put("isLeftKey", this.isLeftKey);
        }
        if (this.button == null && this.key == null && this.raw != null) {
            ob.put("raw", this.raw);
        }
        return ob.build();
    }

    static {
        mouseButtonToStringMap = new HashMap<MouseButton, String>(){
            {
                this.put(MouseButton.PRIMARY, "LeftMouseButton");
                this.put(MouseButton.SECONDARY, "RightMouseButton");
                this.put(MouseButton.MIDDLE, "MiddleMouseButton");
            }
        };
        keyCodeToStringMap = new HashMap<KeyCode, String>(){
            {
                for (KeyCode c : KeyCode.values()) {
                    this.put(c, c.ueText);
                }
            }
        };
        requireLeftRightKeys = new HashSet<KeyCode>(){
            {
                this.add(KeyCode.CONTROL);
                this.add(KeyCode.SHIFT);
                this.add(KeyCode.ALT);
            }
        };
        hasLeftRightStrings = new HashSet<String>(){
            {
                this.add("LeftControl".toLowerCase());
                this.add("RightControl".toLowerCase());
                this.add("LeftAlt".toLowerCase());
                this.add("RightAlt".toLowerCase());
                this.add("LeftShift".toLowerCase());
                this.add("RightShift".toLowerCase());
            }
        };
        stringToMouseButtonMap = new HashMap<String, MouseButton>(){
            {
                for (Map.Entry<MouseButton, String> entry : mouseButtonToStringMap.entrySet()) {
                    this.put(entry.getValue().toLowerCase(), entry.getKey());
                }
            }
        };
        stringToKeyCodeMap = new HashMap<String, KeyCode>(){
            {
                for (Map.Entry<KeyCode, String> entry : keyCodeToStringMap.entrySet()) {
                    KeyCode k = entry.getKey();
                    String s = entry.getValue().toLowerCase();
                    if (requireLeftRightKeys.contains((Object)k)) {
                        this.put("left" + s, k);
                        this.put("right" + s, k);
                        continue;
                    }
                    this.put(s, k);
                }
            }
        };
    }

    private static class KeyBuilder {
        MouseButton button;
        MouseWheelScroll scroll;
        KeyCode key;
        boolean isLeftKey;
        String raw;

        private KeyBuilder() {
        }

        Key build() {
            if (this.button != null) {
                return new Key(this.button);
            }
            if (this.scroll != null) {
                return new Key(this.scroll);
            }
            if (this.key != null) {
                return new Key(this.key, this.isLeftKey);
            }
            return new Key(this.raw);
        }
    }
}

