/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.entity.input;

import vjson.JSON;
import vjson.deserializer.rule.IntRule;
import vjson.deserializer.rule.ObjectRule;
import vjson.deserializer.rule.Rule;
import vjson.deserializer.rule.StringRule;
import vjson.util.ObjectBuilder;

public class MouseWheelScroll {
    public final Direction direction;
    public final int value;
    public static final Rule<MouseWheelScroll> rule = ObjectRule.builder(() -> new MouseWheelScrollBuilder(), MouseWheelScrollBuilder::build, builder -> builder.put("direction", (o, it) -> {
        o.direction = Direction.valueOf(it);
    }, (Rule)StringRule.get()).put("value", (o, it) -> {
        o.value = it;
    }, (Rule)IntRule.get()));

    public MouseWheelScroll(Direction direction) {
        this.direction = direction;
        this.value = 0;
    }

    public MouseWheelScroll(Direction direction, int value) {
        this.direction = direction;
        this.value = value;
    }

    public JSON.Object toJson() {
        return new ObjectBuilder().put("direction", this.direction.name()).put("value", this.value).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MouseWheelScroll that = (MouseWheelScroll)o;
        if (this.value != that.value) {
            return false;
        }
        return this.direction == that.direction;
    }

    public int hashCode() {
        int result = this.direction.hashCode();
        result = 31 * result + this.value;
        return result;
    }

    public String toString() {
        if (this.value == 0) {
            return "scroll-" + this.direction.name().toLowerCase();
        }
        return "scroll-" + this.direction.name().toLowerCase() + ":" + this.value;
    }

    public static enum Direction {
        UP,
        DOWN;

    }

    private static class MouseWheelScrollBuilder {
        Direction direction;
        int value;

        private MouseWheelScrollBuilder() {
        }

        MouseWheelScroll build() {
            return new MouseWheelScroll(this.direction, this.value);
        }
    }
}

