/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.manager.audio;

import io.vproxy.vfx.manager.audio.AudioWrapper;
import io.vproxy.vfx.util.FXUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.concurrent.ThreadLocalRandom;

public class AudioGroup {
    private static final Comparator<AudioWrapper> comparator = (a, b) -> {
        if (a.isLastPlayed()) {
            return 1;
        }
        if (b.isLastPlayed()) {
            return -1;
        }
        return a.getCount() - b.getCount();
    };
    private final LinkedList<AudioWrapper> queue = new LinkedList();

    public AudioGroup(AudioWrapper[] clips) {
        for (AudioWrapper c : clips) {
            if (c == null) continue;
            this.queue.add(c);
        }
        this.queue.sort(comparator);
    }

    public void play() {
        FXUtils.runOnFX(this::playFX);
    }

    private void playFX() {
        if (this.queue.size() == 0) {
            return;
        }
        if (this.queue.size() == 1) {
            AudioWrapper audio = this.queue.peek();
            if (audio != null) {
                audio.play();
            }
            return;
        }
        AudioWrapper last = this.queue.peekLast();
        boolean lastRemoved = false;
        if (last.isLastPlayed()) {
            this.queue.removeLast();
            last.setLastPlayed(false);
            lastRemoved = true;
        }
        ArrayList<AudioWrapper> ls = new ArrayList<AudioWrapper>();
        int lastCount = -1;
        for (AudioWrapper a : this.queue) {
            if (lastCount == -1) {
                lastCount = a.getCount();
                ls.add(a);
                continue;
            }
            if (lastCount != a.getCount()) break;
            ls.add(a);
        }
        AudioWrapper audio = (AudioWrapper)ls.get(ThreadLocalRandom.current().nextInt(ls.size()));
        this.queue.remove(audio);
        audio.play();
        audio.setLastPlayed(true);
        if (lastRemoved) {
            this.queue.add(last);
        }
        this.queue.add(audio);
    }
}

