/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.manager.audio;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.media.AudioClip;

public class AudioManager {
    private static final AudioManager instance = new AudioManager();
    private final Map<String, AudioClip> map = new ConcurrentHashMap<String, AudioClip>();
    private final WeakHashMap<String, AudioClip> weakMap = new WeakHashMap();

    public static AudioManager get() {
        return instance;
    }

    private AudioManager() {
    }

    public AudioClip loadAudio(String path) {
        try {
            return this.loadAudio(path, false);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public AudioClip loadAudio(String path, boolean throwException) throws Exception {
        AudioClip audio;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((audio = this.map.get(path)) == null) {
            audio = this.weakMap.get(path);
        }
        if (audio != null) {
            assert (Logger.lowLevelDebug((String)("using cached audio: " + path)));
            return audio;
        }
        try {
            URL res = this.getClass().getClassLoader().getResource(path);
            if (res == null) {
                Logger.error((LogType)LogType.FILE_ERROR, (String)("unable to find resource for audio " + path));
                if (throwException) {
                    throw new IOException("cannot find audio " + path);
                }
                return null;
            }
            audio = new AudioClip(res.toExternalForm());
        }
        catch (Exception e) {
            Logger.error((LogType)LogType.FILE_ERROR, (String)("failed loading audio " + path), (Throwable)e);
            if (throwException) {
                throw e;
            }
            return null;
        }
        this.map.put(path, audio);
        assert (Logger.lowLevelDebug((String)("new audio loaded: " + path)));
        return audio;
    }

    public AudioClip weakRefAudio(String path) {
        AudioClip audio = this.map.remove(path);
        if (audio == null) {
            return null;
        }
        this.weakMap.put(path, audio);
        return audio;
    }

    public void removeAudio(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!this.map.containsKey(path) && !this.weakMap.containsKey(path)) {
            return;
        }
        this.map.remove(path);
        this.weakMap.remove(path);
        assert (Logger.lowLevelDebug((String)("audio removed: " + path)));
    }
}

