/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.manager.font;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.vfx.manager.font.FontProvider;
import io.vproxy.vfx.manager.font.FontSettings;
import io.vproxy.vfx.manager.font.FontUsage;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.theme.Theme;
import java.io.InputStream;
import java.util.function.Function;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextInputControl;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class FontManager {
    private static final FontManager instance = new FontManager();
    private FontProvider provider;
    public static final String FONT_NAME_Default = Font.getDefault().getFamily();
    public static final String FONT_NAME_SmileySansOblique = "Smiley Sans Oblique";
    public static final String FONT_NAME_NotoSansSCRegular = "Noto Sans SC Regular";
    public static final String FONT_NAME_JetBrainsMono = "JetBrains Mono";

    private FontManager() {
        Font font = Font.loadFont((InputStream)this.getClass().getResourceAsStream("/io/vproxy/vfx/res/font/SmileySans-Oblique.otf"), (double)1.0);
        if (font == null) {
            Logger.error((LogType)LogType.FILE_ERROR, (String)"failed loading font: SmileySans-Oblique");
        }
        if ((font = Font.loadFont((InputStream)this.getClass().getResourceAsStream("/io/vproxy/vfx/res/font/NotoSansSC-Regular.otf"), (double)1.0)) == null) {
            Logger.error((LogType)LogType.FILE_ERROR, (String)"failed loading font: NotoSansSC-Regular");
        }
        if ((font = Font.loadFont((InputStream)this.getClass().getResourceAsStream("/io/vproxy/vfx/res/font/JetBrainsMono-Regular.ttf"), (double)1.0)) == null) {
            Logger.error((LogType)LogType.FILE_ERROR, (String)"failed loading font: JetBrainsMono-Regular");
        }
    }

    public static FontManager get() {
        return instance;
    }

    public void setFontProvider(FontProvider provider) {
        this.provider = provider;
    }

    private FontProvider getProvider() {
        if (this.provider == null) {
            this.setFontProvider(Theme.current().fontProvider());
        }
        return this.provider;
    }

    public void setFont(Labeled labeled) {
        this.setFont(FontUsages.defaultUsage, labeled);
    }

    public void setFont(Labeled labeled, Function<FontSettings, FontSettings> apply) {
        this.setFont(FontUsages.defaultUsage, labeled, apply);
    }

    public void setFont(FontUsage usage, Labeled labeled) {
        FontSettings settings = new FontSettings();
        this.getProvider().apply(usage, settings);
        labeled.setFont(settings.build());
    }

    public void setFont(FontUsage usage, Labeled labeled, Function<FontSettings, FontSettings> apply) {
        FontSettings settings = new FontSettings();
        this.getProvider().apply(usage, settings);
        apply.apply(settings);
        labeled.setFont(settings.build());
    }

    public void setFont(TextInputControl input) {
        this.setFont(FontUsages.defaultUsage, input);
    }

    public void setFont(TextInputControl input, Function<FontSettings, FontSettings> apply) {
        this.setFont(FontUsages.defaultUsage, input, apply);
    }

    public void setFont(FontUsage usage, TextInputControl input) {
        FontSettings settings = new FontSettings();
        this.getProvider().apply(usage, settings);
        input.setFont(settings.build());
    }

    public void setFont(FontUsage usage, TextInputControl input, Function<FontSettings, FontSettings> apply) {
        FontSettings settings = new FontSettings();
        this.getProvider().apply(usage, settings);
        apply.apply(settings);
        input.setFont(settings.build());
    }

    public void setFont(Text text) {
        this.setFont(FontUsages.defaultUsage, text);
    }

    public void setFont(Text text, Function<FontSettings, FontSettings> apply) {
        this.setFont(FontUsages.defaultUsage, text, apply);
    }

    public void setFont(FontUsage usage, Text text) {
        FontSettings settings = new FontSettings();
        this.getProvider().apply(usage, settings);
        text.setFont(settings.build());
    }

    public void setFont(FontUsage usage, Text text, Function<FontSettings, FontSettings> apply) {
        FontSettings settings = new FontSettings();
        this.getProvider().apply(usage, settings);
        apply.apply(settings);
        text.setFont(settings.build());
    }
}

