/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.manager.image;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.vfx.util.FXUtils;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;

public class ImageManager {
    private static final ImageManager instance = new ImageManager();
    private final Map<String, Image> map = new ConcurrentHashMap<String, Image>();
    private final WeakHashMap<String, Image> weakMap = new WeakHashMap();

    public static ImageManager get() {
        return instance;
    }

    private ImageManager() {
        this.loadBlackAndChangeColor("io/vproxy/vfx/res/image/close.png", Map.of("red", -1217954, "white", -1));
        this.loadBlackAndChangeColor("io/vproxy/vfx/res/image/maximize.png", Map.of("white", -1, "green", -10369964));
        this.loadBlackAndChangeColor("io/vproxy/vfx/res/image/reset-window-size.png", Map.of("white", -1, "green", -10369964));
        this.loadBlackAndChangeColor("io/vproxy/vfx/res/image/iconify.png", Map.of("white", -1, "yellow", -737969));
        this.loadBlackAndChangeColor("io/vproxy/vfx/res/image/arrow.png", Map.of("white", -1));
    }

    public Image load(String path) {
        try {
            return this.load(path, false);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public Image load(String path, boolean throwException) throws Exception {
        Image image;
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if ((image = this.map.get(path)) == null) {
            image = this.weakMap.get(path);
        }
        if (image != null) {
            assert (Logger.lowLevelDebug((String)("using cached image: " + (String)path)));
            return image;
        }
        try {
            image = new Image((String)path, false);
        }
        catch (Exception e) {
            Logger.error((LogType)LogType.FILE_ERROR, (String)("failed loading image " + (String)path), (Throwable)e);
            if (throwException) {
                throw e;
            }
            return null;
        }
        this.map.put((String)path, image);
        assert (Logger.lowLevelDebug((String)("new image loaded: " + (String)path)));
        return image;
    }

    public void loadBlackAndChangeColor(String path, Map<String, Integer> argbs) {
        Image img;
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if ((img = this.load((String)path)) == null) {
            return;
        }
        for (Map.Entry<String, Integer> entry : argbs.entrySet()) {
            String name = entry.getKey();
            int setArgb = entry.getValue();
            WritableImage wImg = FXUtils.changeColorOfBlackImage(img, setArgb);
            String newPath = (String)path + ":" + name;
            assert (Logger.lowLevelDebug((String)("new image loaded: " + newPath)));
            this.map.put(newPath, (Image)wImg);
        }
    }

    public Image loadSubImageOrMake(String baseName, String subName, Function<Image, Image> makeFunc) {
        String key;
        Image img;
        if (!((String)baseName).startsWith("/")) {
            baseName = "/" + (String)baseName;
        }
        if ((img = this.map.get(key = (String)baseName + ":" + subName)) == null) {
            img = this.weakMap.get(key);
        }
        if (img != null) {
            assert (Logger.lowLevelDebug((String)("using cached image: " + key)));
            return img;
        }
        img = this.map.get(baseName);
        if (img == null) {
            img = this.weakMap.get(baseName);
        }
        if (img == null) {
            Logger.warn((LogType)LogType.ALERT, (String)("unable to find base image " + (String)baseName + ", cannot make sub image for it"));
            return null;
        }
        if ((img = makeFunc.apply(img)) == null) {
            Logger.warn((LogType)LogType.ALERT, (String)("failed making image for " + key + ", the make function returns null"));
            return null;
        }
        this.map.put(key, img);
        assert (Logger.lowLevelDebug((String)("new image loaded: " + key)));
        return img;
    }

    public Image weakRef(String path) {
        Image audio = this.map.remove(path);
        if (audio == null) {
            return null;
        }
        this.weakMap.put(path, audio);
        return audio;
    }

    public void remove(String path) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!this.map.containsKey(path) && !this.weakMap.containsKey(path)) {
            return;
        }
        this.map.remove(path);
        this.weakMap.remove(path);
        assert (Logger.lowLevelDebug((String)("image removed: " + (String)path)));
    }
}

