/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.robot;

import io.vproxy.base.util.LogType;
import io.vproxy.base.util.Logger;
import io.vproxy.vfx.entity.input.Key;
import io.vproxy.vfx.entity.input.MouseWheelScroll;
import io.vproxy.vfx.util.FXUtils;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.MultiResolutionImage;
import java.util.List;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseButton;
import javafx.scene.robot.Robot;
import javafx.stage.Screen;

public class RobotWrapper {
    private final Robot robot = new Robot();
    private final java.awt.Robot awtRobot;

    public RobotWrapper() {
        java.awt.Robot awtRobot;
        try {
            awtRobot = new java.awt.Robot();
        }
        catch (AWTException e) {
            Logger.error((LogType)LogType.SYS_ERROR, (String)"failed creating awt robot", (Throwable)e);
            awtRobot = null;
        }
        this.awtRobot = awtRobot;
    }

    public void press(Key key) {
        if (key.button != null) {
            FXUtils.runOnFX(() -> this.robot.mousePress(new MouseButton[]{key.button}));
            assert (Logger.lowLevelDebug((String)("mouse press: " + key)));
        } else if (key.scroll != null) {
            int n = key.scroll.value;
            if (n == 0) {
                n = 1;
            }
            if (key.scroll.direction == MouseWheelScroll.Direction.UP) {
                n = -n;
            }
            int fn = n;
            FXUtils.runOnFX(() -> this.robot.mouseWheel(fn));
            assert (Logger.lowLevelDebug((String)("mouse wheel: " + key)));
        } else if (key.key != null) {
            FXUtils.runOnFX(() -> this.robot.keyPress(key.key.java));
            assert (Logger.lowLevelDebug((String)("key press: " + key)));
        }
    }

    public void release(Key key) {
        if (key.button != null) {
            FXUtils.runOnFX(() -> this.robot.mouseRelease(new MouseButton[]{key.button}));
            assert (Logger.lowLevelDebug((String)("mouse release: " + key)));
        } else if (key.key != null) {
            FXUtils.runOnFX(() -> this.robot.keyRelease(key.key.java));
            assert (Logger.lowLevelDebug((String)("key release: " + key)));
        }
    }

    public javafx.scene.image.Image captureScreen(Screen screen) {
        assert (Logger.lowLevelDebug((String)("screen capture: " + screen)));
        Rectangle2D bounds = screen.getBounds();
        return this.capture0(null, bounds.getMinX(), bounds.getMinY(), (int)bounds.getWidth(), (int)bounds.getHeight(), true);
    }

    public javafx.scene.image.Image capture(double x, double y, int width, int height) {
        return this.capture(null, x, y, width, height);
    }

    public javafx.scene.image.Image capture(WritableImage img, double x, double y, int width, int height) {
        return this.capture(img, x, y, width, height, false);
    }

    public javafx.scene.image.Image capture(WritableImage img, double x, double y, int width, int height, boolean tryAwt) {
        assert (Logger.lowLevelDebug((String)("partial capture: (" + x + ", " + y + ") + (" + width + " * " + height + ")")));
        return this.capture0(img, x, y, width, height, tryAwt);
    }

    private javafx.scene.image.Image capture0(WritableImage img, double x, double y, int width, int height, boolean tryAwt) {
        MultiResolutionImage mi;
        List<Image> ls;
        if (tryAwt && this.awtRobot != null && !(ls = (mi = this.awtRobot.createMultiResolutionScreenCapture(new Rectangle((int)x, (int)y, width, height))).getResolutionVariants()).isEmpty()) {
            Image i = ls.get(ls.size() - 1);
            boolean useAwt = false;
            if (img == null) {
                useAwt = true;
            } else {
                int w = i.getWidth(null);
                int h = i.getHeight(null);
                if ((double)w <= img.getWidth() && (double)h <= img.getHeight()) {
                    useAwt = true;
                }
            }
            if (useAwt) {
                assert (Logger.lowLevelDebug((String)"using awt captured image"));
                return SwingFXUtils.toFXImage((BufferedImage)FXUtils.convertToBufferedImage(i), (WritableImage)img);
            }
        }
        assert (Logger.lowLevelDebug((String)"using javafx captured image"));
        return this.robot.getScreenCapture(img, x, y, (double)width, (double)height);
    }

    public Image awtCapture(int x, int y, int width, int height) {
        MultiResolutionImage mi = this.awtRobot.createMultiResolutionScreenCapture(new Rectangle(x, y, width, height));
        List<Image> ls = mi.getResolutionVariants();
        if (ls.isEmpty()) {
            return null;
        }
        return ls.get(ls.size() - 1);
    }

    public void mouseMove(double x, double y) {
        assert (Logger.lowLevelDebug((String)("mouse move: (" + x + ", " + y + ")")));
        FXUtils.runOnFX(() -> this.robot.mouseMove(x, y));
    }

    public Point2D getMousePosition() {
        return this.robot.getMousePosition();
    }

    public void mouseWheel(int wheelAmt) {
        assert (Logger.lowLevelDebug((String)("mouse wheel: " + wheelAmt)));
        FXUtils.runOnFX(() -> this.robot.mouseWheel(wheelAmt));
    }
}

