/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.theme;

import io.vproxy.vfx.manager.font.FontProvider;
import io.vproxy.vfx.theme.impl.DarkTheme;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;

public abstract class Theme {
    private static Theme currentTheme;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Theme current() {
        if (currentTheme != null) {
            return currentTheme;
        }
        Class<Theme> clazz = Theme.class;
        synchronized (Theme.class) {
            if (currentTheme != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return currentTheme;
            }
            currentTheme = new DarkTheme();
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentTheme;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTheme(Theme theme) {
        Class<Theme> clazz = Theme.class;
        synchronized (Theme.class) {
            if (currentTheme != null) {
                throw new IllegalStateException("currentTheme is already set");
            }
            currentTheme = theme;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public abstract FontProvider fontProvider();

    public abstract Color normalTextColor();

    public abstract Color borderColor();

    public abstract Color borderColorLight();

    public abstract Color borderColorDark();

    public Color windowBorderColor() {
        return this.borderColor();
    }

    public Color windowBorderColorLight() {
        return this.borderColorLight();
    }

    public Color windowBorderColorDark() {
        return this.borderColorDark();
    }

    public abstract Color sceneBackgroundColor();

    public abstract Color subSceneBackgroundColor();

    public LinearGradient makeVerticalSubSceneBackgroundGradient() {
        return new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Theme.current().sceneBackgroundColor()), new Stop(1.0, Theme.current().subSceneBackgroundColor())});
    }

    public abstract Image windowCloseButtonNormalImage();

    public abstract Image windowCloseButtonHoverImage();

    public abstract Image windowMaximizeButtonNormalImage();

    public abstract Image windowMaximizeButtonHoverImage();

    public abstract Image windowResetWindowSizeButtonNormalImage();

    public abstract Image windowResetWindowSizeButtonHoverImage();

    public abstract Image windowIconifyButtonNormalImage();

    public abstract Image windowIconifyButtonHoverImage();

    public Color fusionButtonNormalBackgroundColor() {
        return this.sceneBackgroundColor();
    }

    public abstract Color fusionButtonHoverBackgroundColor();

    public abstract Color fusionButtonDownBackgroundColor();

    public abstract Color fusionButtonAnimatingBorderLightColor();

    public Color transparentFusionButtonNormalBackgroundColor() {
        return this.transparentFusionPaneNormalBackgroundColor();
    }

    public Color transparentFusionButtonHoverBackgroundColor() {
        return this.transparentFusionPaneHoverBackgroundColor();
    }

    public abstract Color transparentFusionButtonDownBackgroundColor();

    public boolean enableFusionButtonAnimation() {
        return true;
    }

    public Color fusionPaneNormalBackgroundColor() {
        return this.sceneBackgroundColor();
    }

    public abstract Color fusionPaneHoverBackgroundColor();

    public abstract Color fusionPaneBorderColor();

    public Color transparentFusionPaneNormalBackgroundColor() {
        return new Color(0.0, 0.0, 0.0, 0.0);
    }

    public abstract Color transparentFusionPaneHoverBackgroundColor();

    public abstract Color scrollBarColor();

    public Color fusionButtonTextColor() {
        return this.normalTextColor();
    }

    public abstract Color fusionButtonDisabledTextColor();

    public abstract Color coverBackgroundColor();

    public LinearGradient makeCoverGradientBackground() {
        Color color = this.coverBackgroundColor();
        Color initial = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0.0);
        return new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, initial), new Stop(0.6, color), new Stop(1.0, color)});
    }

    public Color tableTextColor() {
        return this.normalTextColor();
    }

    public Color tableHeaderTextColor() {
        return this.normalTextColor();
    }

    public abstract Color tableSortLabelColor();

    public abstract Color tableCellSelectedBackgroundColor();

    public Color tableCellBackgroundColor1() {
        return this.sceneBackgroundColor();
    }

    public abstract Color tableCellBackgroundColor2();

    public abstract Color tableHeaderTopBackgroundColor();

    public abstract Color tableHeaderBottomBackgroundColor();

    public abstract Color progressBarProgressColor();

    public abstract Color progressBarBackgroundColor();

    public Color toggleSwitchBorderColor() {
        return this.borderColor();
    }

    public Color toggleSwitchUnselectedButtonColor() {
        return this.fusionButtonNormalBackgroundColor();
    }

    public Color toggleSwitchUnselectedButtonHoverColor() {
        return this.fusionButtonHoverBackgroundColor();
    }

    public Color toggleSwitchSelectedButtonColor() {
        return this.fusionButtonDownBackgroundColor();
    }

    public abstract Color toggleSwitchUnselectedTrayColor();

    public abstract Color toggleSwitchSelectedTrayColor();

    public Color sliderButtonNormalColor() {
        return this.fusionButtonNormalBackgroundColor();
    }

    public Color sliderButtonHoverColor() {
        return this.fusionButtonHoverBackgroundColor();
    }

    public Color sliderButtonDownColor() {
        return this.fusionButtonDownBackgroundColor();
    }

    public Color sliderButtonBorderColor() {
        return this.borderColor();
    }

    public Color rangeSliderButtonNormalColor() {
        return this.fusionButtonNormalBackgroundColor();
    }

    public Color rangeSliderButtonHoverColor() {
        return this.fusionButtonHoverBackgroundColor();
    }

    public Color rangeSliderButtonDownColor() {
        return this.fusionButtonDownBackgroundColor();
    }

    public Color rangeSliderButtonBorderColor() {
        return this.borderColor();
    }

    public Color rangeSliderBackgroundColor() {
        return this.progressBarBackgroundColor();
    }

    public Color rangeSliderRangeColor() {
        return this.progressBarProgressColor();
    }

    public Color fusionWrapperBackgroundColor() {
        return this.sceneBackgroundColor();
    }
}

