/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.vfx.ui.alert;

import io.vproxy.base.util.Logger;
import io.vproxy.vfx.manager.font.FontManager;
import io.vproxy.vfx.manager.font.FontUsage;
import io.vproxy.vfx.manager.font.FontUsages;
import io.vproxy.vfx.manager.internal_i18n.InternalI18n;
import io.vproxy.vfx.ui.alert.ThemeAlertBase;
import io.vproxy.vfx.ui.wrapper.ThemeLabel;
import io.vproxy.vfx.util.FXUtils;
import javafx.scene.control.Alert;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Region;

public class SimpleAlert
extends ThemeAlertBase {
    private SimpleAlert(String title, String contentText, final FontUsage fontUsage) {
        Logger.alert((String)("SimpleAlert: [" + title + "] " + contentText));
        this.setTitle(title);
        ThemeLabel alertMessage = new ThemeLabel(contentText){
            {
                super(text);
                this.setWrapText(true);
                FontManager.get().setFont(fontUsage, (Labeled)this);
            }
        };
        FXUtils.observeWidth(this.getSceneGroup().getNode(), (Region)alertMessage, -40.0);
        this.alertMessagePane.getChildren().add((Object)alertMessage);
    }

    private static String typeToTitle(Alert.AlertType type) {
        if (type == Alert.AlertType.INFORMATION) {
            return InternalI18n.get().alertInfoTitle();
        }
        if (type == Alert.AlertType.WARNING) {
            return InternalI18n.get().alertWarningTitle();
        }
        if (type == Alert.AlertType.ERROR) {
            return InternalI18n.get().alertErrorTitle();
        }
        return type.name();
    }

    public static void show(Alert.AlertType type, String contentText) {
        SimpleAlert.show(SimpleAlert.typeToTitle(type), contentText);
    }

    public static void show(Alert.AlertType type, String contentText, FontUsage fontUsage) {
        SimpleAlert.show(SimpleAlert.typeToTitle(type), contentText, fontUsage);
    }

    public static void showAndWait(Alert.AlertType type, String contentText) {
        SimpleAlert.showAndWait(SimpleAlert.typeToTitle(type), contentText);
    }

    public static void showAndWait(Alert.AlertType type, String contentText, FontUsage fontUsage) {
        SimpleAlert.showAndWait(SimpleAlert.typeToTitle(type), contentText, fontUsage);
    }

    public static void show(String title, String contentText) {
        SimpleAlert.show(title, contentText, FontUsages.alert);
    }

    public static void show(String title, String contentText, FontUsage fontUsage) {
        FXUtils.runOnFX(() -> new SimpleAlert(title, contentText, fontUsage).show());
    }

    public static void showAndWait(String title, String contentText) {
        SimpleAlert.showAndWait(title, contentText, FontUsages.alert);
    }

    public static void showAndWait(String title, String contentText, FontUsage fontUsage) {
        new SimpleAlert(title, contentText, fontUsage).showAndWait();
    }
}

